package cn.smarthse.radiationTraining.modules.wqxx.param.integraLog;

import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;


/**
 * <p>
 * 劳动者学习档案列表 vo
 * </p>
 *
 * @author wuxq
 * @since 2023-8-30
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class StudyArchivesSearchParam extends PageParam {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("cid")
    private Long cid;

    @ApiModelProperty("userId")
    private Long userId;

    @ApiModelProperty("年份")
    private Integer year;

    @ApiModelProperty(value = "年份", hidden = true)
    private Boolean isAdminSearch = true;

    @ApiModelProperty(value = "用户名", hidden = true)
    private String userLoginName;

    @ApiModelProperty(value = "姓名", hidden = true)
    private String userName;

    @ApiModelProperty(value = "手机号", hidden = true)
    private String userPhone;
}
