package cn.smarthse.radiationTraining.modules.wqxx.param.SQuestion;

import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
* 卫企学习：试题库-选择题
* @TableName s_question
*/
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("s_question")
@ApiModel(value="SQuestion对象", description="卫企学习：试题库-选择题")
public class SQuestionEditParam extends UserEditParam implements Serializable {

    /**
    * 
    */
    
    @ApiModelProperty("")
    private Long id;
    /**
    * 试题类别（1-单选题；2-多选题；3-填空题；4-判断题）
    */
    @ApiModelProperty("试题类别（1-单选题；2-多选题；3-填空题；4-判断题）")
    private Integer type;
    /**
    * 题干
    */
    
    @ApiModelProperty("题干")
    private String stem;
    /**
    * 状态（0：已禁用(不用的试题,过时的试题)；1：未入库(草稿状态)；2：已入库；）
    */
    @ApiModelProperty("状态（0：已禁用(不用的试题,过时的试题)；1：未入库(草稿状态)；2：已入库；）")
    private Integer state;
    /**
    * 选项A(对)
    */
    
    @ApiModelProperty("选项A(对)")
    private String optionA;
    /**
    * 选项B(错)
    */
    
    @ApiModelProperty("选项B(错)")
    private String optionB;
    /**
    * 选项C
    */
    
    @ApiModelProperty("选项C")
    private String optionC;
    /**
    * 选项D
    */
    
    @ApiModelProperty("选项D")
    private String optionD;
    /**
    * 选项E
    */
    
    @ApiModelProperty("选项E")
    private String optionE;
    /**
    * 选项F
    */
    
    @ApiModelProperty("选项F")
    private String optionF;
    /**
    * 选项G
    */
    
    @ApiModelProperty("选项G")
    private String optionG;
    /**
    * 正确答案（多选：AB）
    */
    
    @ApiModelProperty("正确答案（多选：AB）")
    private String answer;
    /**
    * 解析
    */
    
    @ApiModelProperty("解析")
    private String analysis;

}
