package cn.smarthse.radiationTraining.modules.wqxx.model.vo.integraLog;

import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


/**
 * <p>
 * 劳动者学习档案列表 vo
 * </p>
 *
 * @author wuxq
 * @since 2023-8-30
 */
@Data
public class StaffStudyArchivesVo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("id")
    private Long userId;

    @ApiModelProperty(value = "年度")
    private Integer years;

    @ApiModelProperty(value = "姓名")
    private String name;

    @ApiModelProperty(value = "账号")
    private String username;

    @ApiModelProperty(value = "手机号")
    private String phone;

    @ApiModelProperty("cid")
    private Long cid;

    @ApiModelProperty(value = "单位名称")
    private String unitName;

    @ApiModelProperty(value = "总积分")
    private int integralTotal;

    @ApiModelProperty(value = "总积分")
    private int challengeIntegralTotal;

    @ApiModelProperty(value = "公司内排名")
    private Integer unitRanking;

    @ApiModelProperty(value = "省内排名")
    private Integer provinceRanking;

    @ApiModelProperty(value = "挑战答题省内排名")
    private Integer challengeRanking;

    public String getPhone() {
        if(StringUtils.isEmpty(this.phone) && this.checkPhoneNumber(this.username)){
            return this.username;
        }
        return this.phone;
    }

    public boolean checkPhoneNumber(String phoneNumber) {
        String pattern = "^(86)?1[3-9]\\d{9}$";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(phoneNumber);
        return m.matches();
    }
}
