package cn.smarthse.radiationTraining.modules.wqxx.model.vo.answerExercise;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
* 用户-答题试卷vo
*/
@Data
@EqualsAndHashCode(callSuper = false)
public class SUserExamVo implements Serializable {
    private static final long serialVersionUID = 7752970291272949138L;

    @ApiModelProperty("用户试卷id")
    private Long id;

    /**
     * 用户账号id
     */
    @ApiModelProperty("用户账号id")
    private Long userId;

    /**
     * 试卷id
     */
    @ApiModelProperty("试卷id")
    private Long examId;

    /**
     * 试卷名称
     */
    @ApiModelProperty("试卷名称")
    private String examName;

    /**
     * 考试类型(4-每周；5-专项；6-挑战)
     */
    @ApiModelProperty("考试类型(4-每周；5-专项；6-挑战)")
    private Integer type;

    /**
     * 得分
     */
    @ApiModelProperty("得分")
    private Integer totalScore;

    /**
     * 答题状态(0-未答题;1-进行中；2-已完成；)
     */
    @ApiModelProperty("答题状态(0-未答题;1-进行中；2-已完成；)")
    private Integer status;

    /**
     * 答题已完成类型(0-无；1-答题到期)
     */
    @ApiModelProperty("答题已完成类型(0-无；1-答题到期)")
    private Integer doneType;

    /**
     * 积分状态(1-未获取；2-已获取)
     */
    @ApiModelProperty("积分状态(1-未获取；2-已获取)")
    private Integer scoreStatus;

    /**
     * 获取试卷日期
     */
    @ApiModelProperty("获取试卷日期")
    private Date obtainDate;

    /**
     * 回答正确数量
     */
    @ApiModelProperty("回答正确数量")
    private Integer rightNum;

    /**
     * 回答错误数量
     */
    @ApiModelProperty("回答错误数量")
    private Integer incorrectNum;

    /**
     * 开始作答时间
     */
    @ApiModelProperty("开始作答时间")
    private Date beginTime;

    /**
     * 结束作答时间
     */
    @ApiModelProperty("结束作答时间")
    private Date endTime;

    /**
     * 是否为新创建
     */
    @ApiModelProperty("是否为新创建")
    private Boolean isNewCreate = false;

    /**
     * 是否已达积分上限
     */
    @ApiModelProperty("是否已达积分上限")
    private Boolean hasPeaked = false;

    /**
     * 创建日期
     */
    @ApiModelProperty("创建日期")
    private Date createDate;


}
