package cn.smarthse.radiationTraining.modules.wqxx.entity;

import java.io.Serializable;

import java.util.Date;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.baomidou.mybatisplus.annotation.TableName;

/**
* 卫企学习：用户-视频-学习时长（一个人一个视频只有一条数据）
* @TableName s_user_video_learn
*/
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("s_user_video_learn")
@ApiModel(value="SUserVideoLearn对象", description="卫企学习：用户-视频-学习时长（一个人一个视频只有一条数据）")
public class SUserVideoLearn implements Serializable {

    /**
    * 
    */
    @ApiModelProperty("")
    private Long id;
    /**
    * 用户账号id
    */
    @ApiModelProperty("用户账号id")
    private Long userId;
    /**
    * article.id 或者 video.id
    */
    @ApiModelProperty("article.id 或者 video.id")
    private Long videoId;
    /**
    * 学习状态（0：未学习；1-学习中；2：已学习）
    */
    @ApiModelProperty("学习状态（0：未学习；1-学习中；2：已学习）")
    private Integer status;
    /**
    * 学习时长/ms（计时得到的）
    */
    @ApiModelProperty("学习时长/ms（计时得到的）")
    private Integer learnTime;
    /**
    * 观看结束位置/ms（视频进度）
    */
    @ApiModelProperty("观看结束位置/ms（视频进度）")
    private Integer learnDot;
    /**
    * 创建时间
    */
    @ApiModelProperty("创建时间")
    private Date createDate;
    /**
    * 最后修改时间
    */
    @ApiModelProperty("最后修改时间")
    private Date updateDate;
    /**
    * 是否有效（0-无效，1-有效）
    */
    @ApiModelProperty("是否有效（0-无效，1-有效）")
    private Boolean isValid;
}
