package cn.smarthse.radiationTraining.modules.wqxx.entity;

import java.io.Serializable;

import java.util.Date;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.baomidou.mybatisplus.annotation.TableName;

/**
* 卫企学习：视频/文章-学习时长（一个人一个视频一天只有一条数据）
* @TableName s_user_learn
*/
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("s_user_learn")
@ApiModel(value="SUserLearn对象", description="卫企学习：视频/文章-学习时长（一个人一个视频一天只有一条数据）")
public class SUserLearn implements Serializable {


    @ApiModelProperty("")
    private Long id;
    /**
    * 用户账号id
    */
    @ApiModelProperty("用户账号id")
    private Long userId;
    /**
    * article.id 或者 video.id
    */
    @ApiModelProperty("article.id 或者 video.id")
    private Long businessId;
    /**
    * 积分类型(1-图文；2-视频；)
    */
    @ApiModelProperty("积分类型(1-图文；2-视频；)")
    private Integer type;
    /**
     * 学习状态(1-未完成；2-已完成)
     */
    @ApiModelProperty("学习状态(1-未完成；2-已完成)")
    private Integer state;
    /**
    * 学习时长/m
    */
    @ApiModelProperty("学习时长/m")
    private Integer learnTime;
    /**
     * 学习日期
     */
    @ApiModelProperty("学习日期")
    private Date learnDate;
    /**
    * 创建时间
    */
    @ApiModelProperty("创建时间")
    private Date createDate;
    /**
    * 最后修改时间
    */
    @ApiModelProperty("最后修改时间")
    private Date updateDate;
    /**
    * 是否有效（0-无效，1-有效）
    */
    @ApiModelProperty("是否有效（0-无效，1-有效）")
    private Boolean isValid;
}
