package cn.smarthse.radiationTraining.modules.wqxx.entity;

import java.io.Serializable;

import java.util.Date;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.baomidou.mybatisplus.annotation.TableName;

/**
* 卫企学习：用户-题目-答题结果表
* @TableName s_user_exam_question
*/
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("s_user_exam_question")
@ApiModel(value="SUserExamQuestion对象", description="卫企学习：用户-题目-答题结果表")
public class SUserExamQuestion implements Serializable {

    /**
    * 
    */
    
    @ApiModelProperty("")
    private Long id;
    /**
    * 用户账号id
    */
    @ApiModelProperty("用户账号id")
    private Long userId;
    /**
    * 试卷id
    */
    @ApiModelProperty("试卷id")
    private Long examId;
    /**
     * 用户试卷id
     */
    @ApiModelProperty("用户试卷id")
    private Long userExamId;
    /**
    * 试题id
    */
    @ApiModelProperty("试题id")
    private Long questionId;
    /**
    * 试题类别（1-单选题；2-多选题；3-填空题；4-判断题）
    */
    @ApiModelProperty("试题类别（1-单选题；2-多选题；3-填空题；4-判断题）")
    private Integer type;
    /**
    * 题干（冗余）
    */
    
    @ApiModelProperty("题干（冗余）")
    private String stem;
    /**
    * 选项A（冗余）
    */
    
    @ApiModelProperty("选项A（冗余）")
    private String optionA;
    /**
    * 选项B（冗余）
    */
    
    @ApiModelProperty("选项B（冗余）")
    private String optionB;
    /**
    * 选项C（冗余）
    */
    
    @ApiModelProperty("选项C（冗余）")
    private String optionC;
    /**
    * 选项D（冗余）
    */
    
    @ApiModelProperty("选项D（冗余）")
    private String optionD;
    /**
    * 选项E（冗余）
    */
    
    @ApiModelProperty("选项E（冗余）")
    private String optionE;
    /**
    * 选项F（冗余）
    */
    
    @ApiModelProperty("选项F（冗余）")
    private String optionF;
    /**
    * 选项G（冗余）
    */
    
    @ApiModelProperty("选项G（冗余）")
    private String optionG;
    /**
    * 正确答案（多选：AB）（冗余）
    */
    
    @ApiModelProperty("正确答案（多选：AB）（冗余）")
    private String answer;
    /**
    * 解析（冗余）
    */
    
    @ApiModelProperty("解析（冗余）")
    private String analysis;
    /**
    * 用户作答结果
    */
    
    @ApiModelProperty("用户作答结果")
    private String userAnswer;
    /**
    * 结果判定(对：true；错：false)
    */
    @ApiModelProperty("结果判定(对：true；错：false)")
    private Boolean result;
    /**
    * 本题得分
    */
    @ApiModelProperty("本题得分")
    private Integer score;
    /**
    * 创建时间
    */
    @ApiModelProperty("创建时间")
    private Date createDate;
    /**
    * 最后修改时间
    */
    @ApiModelProperty("最后修改时间")
    private Date updateDate;
    /**
    * 是否有效（0-无效，1-有效）
    */
    @ApiModelProperty("是否有效（0-无效，1-有效）")
    private Boolean isValid;
}
