package cn.smarthse.radiationTraining.modules.wqxx.entity;

import java.io.Serializable;

import java.util.Date;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.baomidou.mybatisplus.annotation.TableName;

/**
* 卫企学习：用户-答题主表
* @TableName s_user_exam
*/
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("s_user_exam")
@ApiModel(value="SUserExam对象", description="卫企学习：用户-答题主表")
public class SUserExam implements Serializable {


    @ApiModelProperty("")
    private Long id;
    
    /**
    * 用户账号id
    */
    @ApiModelProperty("用户账号id")
    private Long userId;

    @ApiModelProperty(value = "公司id")
    private Long cid;
    
    /**
    * 试卷id（应该不需要）
    */
    @ApiModelProperty("试卷id（应该不需要）")
    private Long examId;

    /**
     * 考试类型(4-每周；5-专项；6-挑战)UserExamTypeEnum
     */
    @ApiModelProperty("考试类型(4-每周；5-专项；6-挑战)UserExamTypeEnum")
    private Integer type;

    /**
     * 得分(本次考试获取的积分)
     */
    @ApiModelProperty("得分(本次考试获取的积分)")
    private Integer totalScore;

    /**
     * 答题状态(0-未答题;1-进行中；2-已完成；)
     */
    @ApiModelProperty("答题状态(0-未答题;1-进行中；2-已完成；)")
    private Integer status;

    /**
     * 答题已完成类型(0-无；1-答题到期)
     */
    @ApiModelProperty("答题已完成类型(0-无；1-答题到期)")
    private Integer doneType;

    /**
     * 积分状态(1-未获取；2-已获取)
     */
    @ApiModelProperty("积分状态(1-未获取；2-已获取)")
    private Integer scoreStatus;

    /**
     * 获取试卷日期
     */
    @ApiModelProperty("获取试卷日期")
    private Date obtainDate;

    /**
     * 回答正确数量
     */
    @ApiModelProperty("回答正确数量")
    private Integer rightNum;

    /**
     * 回答错误数量
     */
    @ApiModelProperty("回答错误数量")
    private Integer incorrectNum;

    /**
     * 开始作答时间
     */
    @ApiModelProperty("开始作答时间")
    private Date beginTime;
    
    /**
    * 结束作答时间
    */
    @ApiModelProperty("结束作答时间")
    private Date endTime;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date createDate;
    /**
     * 最后修改时间
     */
    @ApiModelProperty("最后修改时间")
    private Date updateDate;
    
    /**
    * 是否有效（0-无效，1-有效）
    */
    @ApiModelProperty("是否有效（0-无效，1-有效）")
    private Boolean isValid;
}
