package cn.smarthse.radiationTraining.modules.wqxx.entity;

import java.io.Serializable;

import java.util.Date;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.baomidou.mybatisplus.annotation.TableName;

/**
* 卫企学习：答题管理
* @TableName s_exam
*/
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("s_exam")
@ApiModel(value="SExam对象", description="卫企学习：答题管理")
public class SExam implements Serializable {

    /**
    * 
    */
    
    @ApiModelProperty("")
    private Long id;
    /**
    * 答题名称
    */
    
    @ApiModelProperty("答题名称")
    private String name;

    @ApiModelProperty("答题类型：(4-每周；5-专项；6-挑战)")
    private Integer type;
    /**
    * 状态(1：未上架；2：已上架)
    */
    @ApiModelProperty("状态(1：未上架；2：已上架)")
    private Integer status;
    /**
    * 答题人数（可定期维护）
    */
    @ApiModelProperty("答题人数（可定期维护）")
    private Integer totalUser;

    @ApiModelProperty("年份")
    private Integer year;

    @ApiModelProperty("每年的第几周")
    private Integer week;

    /**
    * 发布(上架)时间
    */
    @ApiModelProperty("发布(上架)时间")
    private Date releaseDate;
    /**
    * 发布人id
    */
    @ApiModelProperty("发布人id")
    private Long releaseBy;
    /**
    * 发布人
    */
    
    @ApiModelProperty("发布人")
    private String releaser;
    /**
    * 创建人
    */
    @ApiModelProperty("创建人")
    private Long createBy;
    /**
    * 创建时间
    */
    @ApiModelProperty("创建时间")
    private Date createDate;
    /**
    * 最后修改人ID
    */
    @ApiModelProperty("最后修改人ID")
    private Long updateBy;
    /**
    * 最后修改时间
    */
    @ApiModelProperty("最后修改时间")
    private Date updateDate;
    /**
    * 是否有效（0-无效，1-有效）
    */
    @ApiModelProperty("是否有效（0-无效，1-有效）")
    private Boolean isValid;
}
