package cn.smarthse.radiationTraining.modules.wqxx.entity;

import java.io.Serializable;

import java.util.Date;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.baomidou.mybatisplus.annotation.TableName;

/**
* 卫企学习：图文视频
* @TableName s_article_video
*/
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("s_article_video")
@ApiModel(value="SArticleVideo对象", description="卫企学习：图文视频")
public class SArticleVideo implements Serializable {

    private Long id;

    /**
    * 标题
    */
    @ApiModelProperty("标题")
    private String title;

    /**
    * 类型：1-图文；2-视频；
    */
    @ApiModelProperty("类型：1-图文；2-视频；")
    private String type;

    /**
    * 分类
    */
    @ApiModelProperty("分类")
    private String itype;

    /**
    * 文章内容
    */
    @ApiModelProperty("文章内容")
    private String content;

    /**
    * 文章或视频封面图ids
    */
    @ApiModelProperty("文章或视频封面图ids")
    private String screenshotIds;

    /**
    * 附件ids
    */
    @ApiModelProperty("附件ids")
    private String fileIds;

    /**
    * 作者或来源
    */
    @ApiModelProperty("作者或来源")
    private String author;

    /**
     * 状态：0-草稿；1-上架；2-下架；
     */
    @ApiModelProperty("状态：0-草稿；1-上架；2-下架")
    private Integer state;

    /**
    * 发布(上架)时间
    */
    @ApiModelProperty("发布(上架)时间")
    private Date releaseDate;

    /**
    * 发布人id
    */
    @ApiModelProperty("发布人id")
    private Long releaseBy;

    /**
    * 发布人
    */
    @ApiModelProperty("发布人")
    private String releaser;


    /**
     * 点击量
     */
    @ApiModelProperty("点击量")
    private Integer clickNums;

    /**
    * 创建时间
    */
    @ApiModelProperty("创建时间")
    private Date createDate;

    /**
    * 更新时间
    */
    @ApiModelProperty("更新时间")
    private Date updateDate;

    /**
    * 创建人
    */
    @ApiModelProperty("创建人")
    private Long createBy;

    /**
    * 更新人
    */
    @ApiModelProperty("更新人")
    private Long updateBy;

    /**
    * 是否有效
    */
    @ApiModelProperty("是否有效")
    private Integer isValid;
}
