package cn.smarthse.radiationTraining.modules.training.vo.training;

import cn.smarthse.radiationTraining.modules.training.vo.course.CourseWorkTypeVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * Description:用户个人中心-课程列表-课程 vo
 *
 * @Author:chuhy
 * @create:2022/3/29
 */
@Data
public class UserMyTrainCourseVo implements Serializable {

    private static final long serialVersionUID = -1565192180210259856L;

    @ApiModelProperty("课程id")
    private Long courseId;

    @ApiModelProperty("课程名称")
    private String courseName;

    @ApiModelProperty("考试分数")
    private Integer testScore;

    @ApiModelProperty("已学习时长")
    private String studiedDuration;

    @ApiModelProperty("课程时长")
    private Long courseDuration;

    @ApiModelProperty("是否必过")
    private Byte isPass;

    @ApiModelProperty("是否考试")
    private Byte isTest;

    @ApiModelProperty("课程学习状态(0-未学习；1-学习中；2-已完成)")
    private Byte studyStatus;

    @ApiModelProperty("工作类别")
    private List<CourseWorkTypeVo> workTypeList;
}
