package cn.smarthse.radiationTraining.modules.training.vo.training;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * Description:个人用户-培训基础信息vo
 *
 * @Author:chuhy
 * @create:2022/3/24
 */
@Data
public class UserMyTrainBaseInfoVo implements Serializable {
    private static final long serialVersionUID = -4915607368747904777L;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("培训id")
    private Long tid;

    @ApiModelProperty("培训名称")
    private String trainName;

    @ApiModelProperty("用人单位名称")
    private String unitName;

    @ApiModelProperty("报名时间")
    private Date enrollTime;

    @ApiModelProperty(hidden = true, value = "适用工作类别Code集合(Code和名称在这里不是一一对应的)")
    private String trainWorkTypeCodeList;

    @ApiModelProperty("适用工作类别名称集合")
    private String trainWorkTypeNameList;

    @ApiModelProperty("已学习课程数")
    private Integer studiedProgress;

    @ApiModelProperty("考试进度(1/10)")
    private String testedProgress;

    @ApiModelProperty("所有课程数")
    private Integer courseNum;

    @ApiModelProperty("报名来源(1-个人；2-单位；3-机构；4-医院 SysUserTypeEnum)")
    private Byte enrollSource;

    @ApiModelProperty("状态 (0-退回；1-待培训；2-培训中；3-已取证；4-培训结束 5-待报名)")
    private Byte trainStatus;

    @ApiModelProperty("培训类型")
    private String trainType;

    @ApiModelProperty("培训开始时间")
    private Date trainStarTime;

    @ApiModelProperty("培训结束时间")
    private Date trainEndTime;

    @ApiModelProperty("考试截止时间")
    private Date testEndTime;

    @ApiModelProperty("封面url")
    private String coverUrl;

    @ApiModelProperty("目标证书")
    private String target_certificate;
}
