package cn.smarthse.radiationTraining.modules.training.vo.training;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * Description:后台数据统计Vo
 *
 * @Author:chuhy
 * @create:2022/4/13 16:07
 */
@Data
public class TrainingHomeVo implements Serializable {
    private static final long serialVersionUID = 2547145263950479020L;

    @ApiModelProperty(value="行政区划编码")
    private String areaId = "";

    @ApiModelProperty(value="行政区划名")
    private String areaName = "";

    @ApiModelProperty(value="行政区划等级")
    private Integer areaLevel;

    @ApiModelProperty(value="总报名人次(筛选年份内的报名人次)")
    private int totalEnrollTime;

    // 统计结果上来看可能会有去年报名但今年取证的情况
    @ApiModelProperty(value="总取证人次(筛选年份内的取证人次)")
    private int totalCetTime;

    @ApiModelProperty(value="培训组织次数(以培训开始时间统计)")
    private int trainNum;

    @ApiModelProperty(value="主要负责人/放射工作人员-取证人数(以取证时间统计)")
    private int majorCetNum;

    @ApiModelProperty(value="主要负责人/放射工作人员-取证人次")
    private int majorCetTime;

    @ApiModelProperty(value="职业卫生管理员/放射卫生防护管理人员-取证人数")
    private int managerCetNum;

    @ApiModelProperty(value="职业卫生管理员/放射卫生防护管理人员-取证人次")
    private int managerCetTime;

    @ApiModelProperty(value="更新时间")
    private Date updateTime;

}
