package cn.smarthse.radiationTraining.modules.training.vo.training;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 后台数据统计-清单Vo
 *
 * @author chuhy
 * @date 2022/9/7
 */
@Data
public class TrainingHomeListVo implements Serializable {
    private static final long serialVersionUID = 1647145263950475298L;

    @ApiModelProperty(value="姓名")
    private String uname;

    @ApiModelProperty(value="培训名称")
    private String trainName;

    @ApiModelProperty(value="手机号")
    private String phone;

    @ApiModelProperty(value="单位")
    private String unitName;

    @ApiModelProperty(value="单位所在行政区划")
    private Long unitArea;

    @ApiModelProperty(value="报名时间")
    private Date enrollTime;

    @ApiModelProperty(value="人员类型code")
    private String personTypeCode;

    @ApiModelProperty(value="人员类型名称")
    private String personTypeName;

    @ApiModelProperty(value="培训课程数")
    private String trainCourseNum;

    @ApiModelProperty(value="已学完课程数(学习进度)")
    private Integer studiedProgress;
    
    @ApiModelProperty(value="总课程数(学习进度)")
    private Integer studyProgressTotal;
    
    @ApiModelProperty(value="已通过(考试进度)")
    private Integer testedProgress;
    
    @ApiModelProperty(value="必考必过课程数(考试进度)")
    private Integer testProgressTotal;

    @ApiModelProperty(value="培训状态")
    private Integer trainStatus;

    public String getPersonTypeName() {
        if (this.personTypeCode == null)
            return null;
        if(this.personTypeCode.equals("200001,200002") ||
                this.personTypeCode.equals("200002,200001"))
            return "主要负责人，职业卫生管理人员";
        if(this.personTypeCode.equals("200001"))
            return "主要负责人";
        if(this.personTypeCode.equals("200002"))
            return "职业卫生管理人员";
        return null;
    }

}
