package cn.smarthse.radiationTraining.modules.training.vo.training;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;

/**
 * 人员培训档案导出 Vo
 *
 * @author chuhy
 * @date 2024/3/13
 */
@Data
public class TrainHomeUserExportVo implements Serializable {
    private static final long serialVersionUID = -3610781448415243328L;

    @ExcelIgnore
    private Long id;

    @ExcelProperty(value="人员姓名")
    private String name;

    @ExcelProperty(value="所在单位")
    private String companyName;

    @ExcelProperty(value="行政区划")
    private String areaName;

    @ExcelProperty(value="账号")
    private String userName;

    @ExcelProperty(value="证书类型")
    private String certType;

    @ExcelProperty(value="证书编号")
    private String certificateNo;

    @ExcelProperty(value="发证单位")
    private String trainingUnitName;

    @DateTimeFormat("yyyy-MM-dd")
    @ExcelProperty(value="取证时间")
    private String issueTime;

    @DateTimeFormat("yyyy-MM-dd")
    @ExcelProperty(value="证书有效期")
    private String invalidDate;

    public String getCertType() {
        if (certType == null){
            return "";
        }

        if (certType.equals("200001")){
            return "主要负责人职业卫生管理培训合格证书";
        }
        if (certType.equals("200002")){
            return "职业卫生管理人员职业卫生管理培训合格证";
        }
        if (certType.equals("300003")){
            return "非医用放射工作人员职业卫生管理培训合格证";
        }

        return certType;
    }
}
