package cn.smarthse.radiationTraining.modules.training.vo.training;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 用人单位培训档案 Vo
 *
 * @author chuhy
 * @date 2022/9/26
 */
@Data
public class TrainHomeCropVo implements Serializable {
    private static final long serialVersionUID = 1408550777081605825L;

    @ApiModelProperty(value="用人单位id")
    private Long unitId;

    @ApiModelProperty(value="用人单位userId")
    private Long userId;

    @ApiModelProperty(value="用人单位")
    private String unitName;

    @ApiModelProperty(value="统一社会信用代码")
    private String creditCode;

    @ApiModelProperty(value="行政区划",hidden = true)
    private Long areaId;

    @ApiModelProperty(value="行政区划名称")
    private String areaName;

    @ApiModelProperty(value="注册地址")
    private String areaAddress;

    @ApiModelProperty(value="行业", hidden = true)
    private String industryCode;

    @ApiModelProperty(value="行业名称")
    private String industryName;

    @ApiModelProperty(value="培训次数")
    private Integer trainNum;

    @ApiModelProperty(value="证书数")
    private Integer certNum;

    @ApiModelProperty(value="有效证书数")
    private Integer invalidCertNum;

    @ApiModelProperty(value="主要负责人有效证书数")
    private Integer majorInvalidCertNum;

    @ApiModelProperty(value="'主要负责人'过期证书数")
    private Integer majorOverDueNum;

    @ApiModelProperty(value="'职业卫生管理人员'有效证书数")
    private Integer managerInvalidCertNum;

    @ApiModelProperty(value="'职业卫生管理人员'过期证书数")
    private Integer managerOverDueNum;

    @ApiModelProperty(value="主要负责人证书状态(0-未取证；1-证书过期；2-证书有效)")
    private Integer majorStatus;

    @ApiModelProperty(value="职业卫生管理人员证书状态(0-未取证；1-全部过期；2-部分过期；3-全部有效)")
    private Integer managerStatus;




    @ApiModelProperty(value="'非医放射人员'有效证书数")
    private Integer nonMedicalInvalidCertNum;

    @ApiModelProperty(value="'非医放射人员'过期证书数")
    private Integer nonMedicalOverDueNum;

}
