package cn.smarthse.radiationTraining.modules.training.vo.training;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 用人单位培训档案 Vo
 *
 * @author chuhy
 * @date 2022/9/26
 */
@Data
public class TrainHomeCetVo implements Serializable {
    private static final long serialVersionUID = -8639614993865043027L;

    @ApiModelProperty(value="证书类型")
    private String name;

    @ApiModelProperty(value="人员类型")
    private String certType;

    @ApiModelProperty(value="用人单位")
    private String unitName;

    @ApiModelProperty(value="证书编号")
    private String certificateNo;

    @ApiModelProperty(value="发证单位")
    private String trainingUnitName;

    @ApiModelProperty(value="取证日期")
    private Date issueTime;

    @ApiModelProperty(value="证书有效期至")
    private Date invalidDate;

    @ApiModelProperty(value="证书pdf路径")
    private String pdfUrl;

}
