package cn.smarthse.radiationTraining.modules.training.vo.training;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * Description:个人用户详情-课程列表 vo
 *
 * @Author:chuhy
 * @create:2022/4/11
 */
@Data
public class TrainEnrollCourseVo implements Serializable {
    private static final long serialVersionUID = 4541675458013528496L;

    @ApiModelProperty("课程组名称")
    private String courseGroupName;

    @ApiModelProperty("课程ID")
    private Long courseId;

    @ApiModelProperty("课程名称")
    private String courseName;

    @ApiModelProperty("适用工作类别集合")
    private String trainWorkTypeNameList;

    @ApiModelProperty(value = "危害因素code",hidden = true)
    private String riskFactor;

    @ApiModelProperty("危害因素名称集合")
    private String riskFactorNameList;

    @ApiModelProperty("是否考试")
    private Byte isTest;

    @ApiModelProperty("是否必过")
    private Byte isPass;

    @ApiModelProperty("考试结果")
    private Integer score;

    @ApiModelProperty("课程学习状态(0-未学习；1-学习中；2-已完成)")
    private Byte studyStatus;

    @ApiModelProperty("考试状态(1-考试未通过；2-考试通过)")
    private Byte testStatus;
}
