package cn.smarthse.radiationTraining.modules.training.vo.training;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 放射卫生在线-个人培训档案 Vo
 *
 * @author chuhy
 * @date 2022/9/26
 */
@Data
public class RhoTrainHomeUserVo implements Serializable {
    private static final long serialVersionUID = 5312380245643066762L;

    @ExcelIgnore
    @ApiModelProperty(value="用户id")
    private Long userId;

    @ExcelProperty("人员姓名")
    @ApiModelProperty(value="姓名")
    private String name;

    @ExcelProperty("所在单位")
    @ApiModelProperty(value="单位名称")
    private String companyName;

    @ExcelProperty("行政区划")
    @ApiModelProperty(value="区域名称")
    private String areaName;

    @ExcelProperty("账号")
    @ApiModelProperty(value="账号")
    private String userName;

    @ExcelProperty("培训次数")
    @ApiModelProperty(value="培训次数")
    private Integer trainTimes;

    @ExcelIgnore
    @ApiModelProperty(value = "证书是否有效(0-无有效证书;1-持有效证书)")
    private Integer includeValidCet;

    @ExcelProperty("证书是否有效")
    @ApiModelProperty(value = "证书是否有效(0-无有效证书;1-持有效证书)", hidden = true)
    private String includeValidCetStr;

    public String getIncludeValidCetStr() {
        if (includeValidCet == null) {
            return "";
        }

        if (includeValidCet == 1) {
            return "持有效证书";
        } else {
            return "无有效证书";
        }
    }
}
