package cn.smarthse.radiationTraining.modules.training.vo.training;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 放射卫生在线-用人单位培训档案 Vo
 *
 * @author chuhy
 * @date 2022/9/26
 */
@Data
public class RhoTrainHomeCropVo implements Serializable {
    private static final long serialVersionUID = 7087607356621124465L;

    @ExcelIgnore
    @ApiModelProperty(value="用人单位id")
    private Long unitId;

    @ExcelIgnore
    @ApiModelProperty(value="用人单位userId")
    private Long userId;

    @ExcelProperty("医院名称")
    @ApiModelProperty(value="用人单位")
    private String unitName;

    // @ApiModelProperty(value="统一社会信用代码")
    // private String creditCode;

    @ExcelIgnore
    @ApiModelProperty(value="行政区划",hidden = true)
    private Long areaId;

    @ExcelProperty("行政区划")
    @ApiModelProperty(value="行政区划名称")
    private String areaName;

    @ExcelProperty("培训次数")
    @ApiModelProperty(value="培训次数")
    private Integer trainNum;

    // @ApiModelProperty(value="证书数")
    // private Integer certNum;

    // @ApiModelProperty(value="有效证书数")
    // private Integer invalidCertNum;

    @ExcelProperty("放射工作人员有效证书数")
    @ApiModelProperty(value="'放射工作人员'有效证书数")
    private Integer workInvalidCertNum;

    @ExcelProperty("放射工作人员过期证书数")
    @ApiModelProperty(value="'放射工作人员'过期证书数")
    private Integer workOverDueNum;

    @ExcelIgnore
    @ApiModelProperty(value="'管理人员'有效证书数")
    private Integer managerInvalidCertNum;

    @ExcelIgnore
    @ApiModelProperty(value="'管理人员'过期证书数")
    private Integer managerOverDueNum;

    // @ApiModelProperty(value="主要负责人证书状态(0-未取证；1-证书过期；2-证书有效)")
    // private Integer majorStatus;
    //
    // @ApiModelProperty(value="职业卫生管理人员证书状态(0-未取证；1-全部过期；2-部分过期；3-全部有效)")
    // private Integer managerStatus;

}
