package cn.smarthse.radiationTraining.modules.training.vo.training;

import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @ClassName ExamAlertInfoVo
 * @Description 考试弹窗学习
 * @Author ChenLiang
 * @ModifyDate 2022/4/13 16:27
 */
@Data
@Accessors(chain = true)
public class ExamAlertInfoVo implements Serializable {
    @ApiModelProperty("tuCourseId 学习记录id")
    private Long tuCourseId;
    @ApiModelProperty("考试名称")
    private String name;
    @ApiModelProperty("考试数量")
    private String questionNum;
    @ApiModelProperty("考试时间(分钟)")
    private Integer testDuration;
    @ApiModelProperty("考试总分")
    private Integer totalScore;
    @ApiModelProperty("剩余考试次数")
    private Integer retestLimit;
    @ApiModelProperty("是否已通过考试(0-待考试；1-未通过；2-已通过)")
    private Integer isPassed;
    @ApiModelProperty("考试方式(0-分别考试；1-统一考试)")
    private Byte testMode;
}
