package cn.smarthse.radiationTraining.modules.training.vo.training;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @ClassName CropTrainingListVo
 * @Description 后台管理某个单位培训列表
 * @Author ChenLiang
 * @ModifyDate 2022/4/11 13:12
 */
@Data
@Accessors(chain = true)
public class CropTrainingListVo implements Serializable {
    @ApiModelProperty("培训id")
    private Long tid;
    @ApiModelProperty("培训课程名")
    private String name;
    @ApiModelProperty("课程总数")
    private Integer courseTotalNum;
    @ApiModelProperty("工作类别名")
    private String workTypeNames;
    @ApiModelProperty("工作类别名")
    private String personTypeNames;
    @ApiModelProperty("培训类别")
    private String trainType;
    @ApiModelProperty("培训对象TrainTargetEnum(0-用人单位；21-放射卫生防护管理人员;22-放射工作人员放射防护培训)")
    private Integer trainTarget;
    @ApiModelProperty("报名人数")
    private Integer regNum;
    @ApiModelProperty("合格人数")
    private Integer accNum;
    @ApiModelProperty("培训状态(0-退回；1-待培训；2-培训中；4-培训结束,5-草稿)")
    private Integer trainStatus;
}
