package cn.smarthse.radiationTraining.modules.training.vo.training;

import cn.smarthse.radiationTraining.core.framework.utils.VideoUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @ClassName CourseCatalogueVo
 * @Description 课程培训目录
 * @Author ChenLiang
 * @ModifyDate 2022/3/30 8:33
 */

@Data
@Accessors(chain = true)
public class CourseItemCatalogueVo implements Serializable {
    @ApiModelProperty(value = "课程名")
    private String name;
    @ApiModelProperty(value = "课程名封面")
    private String coverUrl;
    @ApiModelProperty(value = "课程名视频")
    private String videoUrl;
    @ApiModelProperty(value = "培训课程id")
    private Long trainingCourseId;
    @ApiModelProperty(value = "基础课程id")
    private Long courseItemId;
    @ApiModelProperty(value = "用户培训：报名-课程信息id")
    private Long tuCourseId;
    @ApiModelProperty(value = "课程描述")
    private String description;
    @ApiModelProperty(value = "学时")
    private Double classHour;
    @ApiModelProperty(value = "是否考试(0否1是)")
    private String isTest;
    @ApiModelProperty(value = "是否必过(0否1是)")
    private String isPass;
    @ApiModelProperty(value = "是否考试通过(0-待考试；1-未通过；2-已通过)")
    private Integer isPassed;
    @ApiModelProperty(value = "是否可以刷新")
    private Boolean ifCanRefresh;
    @ApiModelProperty(value = "学习时长(秒)")
    private Long stuDurationSec;
    @ApiModelProperty(value = "视频时长(秒)")
    private Long videoDurationSec;
    @ApiModelProperty(value = "课程学习状态：0-未学习；1-学习中；2-已完成；")
    private Integer stuStatus;
    @ApiModelProperty(value = "分数")
    private Integer score;
    @ApiModelProperty(value = "考试次数限制（-1代表无限次）")
    private Integer retestLimitNum;
    @ApiModelProperty(value = "已考次数")
    private Integer testedNum;
    @ApiModelProperty(value = "已考次数")
    private Integer trainStatus;

    public Long getStuDurationSec() {
        if(this.stuDurationSec != null && this.videoDurationSec != null){
            return this.stuStatus == 2 ? this.videoDurationSec : this.stuDurationSec;
        }else {
            return this.stuDurationSec;
        }

    }

    public Boolean getIfCanRefresh() {
        if(isPassed == null || retestLimitNum == null){
            return false;
        }
        return isPassed == 1 && retestLimitNum == 0;
    }
}
