package cn.smarthse.radiationTraining.modules.training.vo.training;

import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.smarthse.common.util.IDCardUtil;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 协会培训-成绩列表 Vo
 *
 * @author chuhy
 */
@Data
public class AssoScoreListVo implements Serializable {
    private static final long serialVersionUID = 8342666874598214204L;

    @ApiModelProperty(value="培训id")
    private Long id;

    @ApiModelProperty(value="培训名称")
    private String trainName;

    @ApiModelProperty(value="培训类型")
    private String trainType;

    @ApiModelProperty(value="培训起始时间")
    private Date trainStarTime;

    @ApiModelProperty(value="培训结束时间")
    private Date trainEndTime;

    @ApiModelProperty(value="证书类型")
    private String personTypeName;

    @ApiModelProperty(value="姓名")
    private String uname;

    @ApiModelProperty(value="账号")
    private String username;

    @ApiModelProperty(value="身份证号")
    private String idCard;

    @ApiModelProperty(value="手机号")
    private String phone;

    @ApiModelProperty(value="所在单位")
    private String cname;

    @ApiModelProperty(value="分数")
    private Integer score;

    @ApiModelProperty(value="是否通过（1-未通过；2-已通过）")
    private Integer result;

    @ApiModelProperty(value="最近一次考试时间")
    private Date latestExamTime;



    public String getPhone() {
        // 手机号脱敏
        return DesensitizedUtil.mobilePhone(phone);
    }

    public String getIdCard() {
        // 身份证脱敏
        return StringUtils.desensitizationCertificateNumber(idCard);
    }

    public String getUname() {
        // 姓名脱敏
        return StringUtils.desensitizationName(uname);
    }

    // 账号脱敏
    public String getUsername() {
        return StringUtils.desensitizationUsernameNumber(username);
    }
}