package cn.smarthse.radiationTraining.modules.training.vo.certificate;

import cn.smarthse.radiationTraining.modules.training.enums.TrainingPersonTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 *
 * 用户证书二维码预览页vo
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/10/12 14:22
 */
@Data
public class TuCertQrVo implements Serializable {

    private static final long serialVersionUID = 3421399580331365041L;

    @ApiModelProperty("证书id")
    private Long id;

    @ApiModelProperty("姓名")
    private String uname;

    @ApiModelProperty("证书类型")
    private String certType;

    @ApiModelProperty("证书编号")
    private String certificateNo;

    @ApiModelProperty("所在单位名称")
    private String unitName;

    @ApiModelProperty("发证单位")
    private String trainingUnitName;

    @ApiModelProperty("发证日期")
    private Date issueTime;

    @ApiModelProperty("证书附件url")
    private String pdfUrl;

    public String getCertType() {

        return TrainingPersonTypeEnum.getNameByValue2(this.certType);
    }
}
