package cn.smarthse.radiationTraining.modules.training.vo.certificate;

import cn.smarthse.radiationTraining.modules.training.enums.TrainingPersonTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
 * <p>
 * 我的证书 vo
 * </p>
 *
 * @author wuxq
 * @since 2022-3-21
 */
@Data
public class MyCertificateVo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("报名详情id")
    private Long enrollDetailId;

    @ApiModelProperty("培训id")
    private Long tid;

    @ApiModelProperty(value = "证书名称")
    private String name = "北京市放射工作人员放射防护知识培训合格证";

    @ApiModelProperty(value = "发证日期")
    private Date issueTime;

    private Date invalidDate;

    @ApiModelProperty(value = "培训名称")
    private String trainingName;
    @ApiModelProperty("培训对象(-1放射培训；0-用人单位；22-放射工作人员放射防护培训；)")
    private Integer trainTarget;

    @ApiModelProperty(value = "培训类型")
    private String trainType;
    @ApiModelProperty(value = "人员类型")
    private String certType;
    @ApiModelProperty(value = "人员类型")
    private String certTypeName;

    @ApiModelProperty(value = "用人单位")
    private String unitName;

    @ApiModelProperty(value = "证书pdf地址")
    private String pdfUrl;

    @ApiModelProperty(value = "证书图片地址")
    private String imgUrl;

    @ApiModelProperty(value = "证书编号")
    private String certificateNo;


    public String getCertTypeName() {
        return this.certType == null ? null : TrainingPersonTypeEnum.getNameByValue2(this.certType);
    }
}
