package cn.smarthse.radiationTraining.modules.training.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.smarthse.radiationTraining.modules.training.enums.GroupTrainingTartgetTypeEnum;
import cn.smarthse.radiationTraining.modules.training.enums.InudstryAllCodeTypeEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingPersonTypeEnum;
import lombok.extern.slf4j.Slf4j;

import java.net.HttpURLConnection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @ClassName VideoUtils
 * @Description 人员类型工具
 * @Author ChenLiang
 * @ModifyDate 2022/3/30 16:37
 */
@Slf4j
public class PersonTypeUtils {
    
    public static boolean checkTTTypeAndPT(String trainingTargetType, List<String> personTypeList){
        if(StrUtil.isBlank(trainingTargetType) || CollUtil.isEmpty(personTypeList)){
            return true;
        }
        Set<String> tttSet = new HashSet<>();
        for (String pt : personTypeList) {
            if(StrUtil.equalsAny(pt,TrainingPersonTypeEnum.MAIN_IN_CHARGE.getValue(),TrainingPersonTypeEnum.HEALTH_ADMIN.getValue(),"0")){
                tttSet.add(GroupTrainingTartgetTypeEnum.UNIT.getValue());
            }

            if(StrUtil.equals(pt,TrainingPersonTypeEnum.RAY_WORK.getValue())){
                tttSet.add(GroupTrainingTartgetTypeEnum.RAY_WORK.getValue());
            }

            if(StrUtil.equals(pt,TrainingPersonTypeEnum.RAY_WORK_NON_MEDICAL.getValue())){
                tttSet.add(GroupTrainingTartgetTypeEnum.RAY_WORK_NON_MEDICAL.getValue());
            }
        }
        if(StrUtil.equals(trainingTargetType, GroupTrainingTartgetTypeEnum.UNIT.getValue())){
            return tttSet.contains(GroupTrainingTartgetTypeEnum.UNIT.getValue());
        }else if(StrUtil.equalsAny(trainingTargetType,GroupTrainingTartgetTypeEnum.RAY_WORK.getValue(),GroupTrainingTartgetTypeEnum.RAY_WORK_NON_MEDICAL.getValue())) {
            return personTypeList.contains(trainingTargetType);
        }
        return true;
    }

    public static boolean checkPtAndIndustry(List<String> personTypeList, List<String> industryCodeList){
        //人员类型相关
        boolean containUnitPT = personTypeList.contains(TrainingPersonTypeEnum.UNIT.getValue()) || personTypeList.contains(TrainingPersonTypeEnum.MAIN_IN_CHARGE.getValue()) || personTypeList.contains(TrainingPersonTypeEnum.HEALTH_ADMIN.getValue());
        boolean containMedicalPT = personTypeList.contains(TrainingPersonTypeEnum.RAY_WORK.getValue());
        boolean containNonMedicalPT = personTypeList.contains(TrainingPersonTypeEnum.RAY_WORK_NON_MEDICAL.getValue());
        //行业相关
        boolean containMedicalIndustry = IndustryTypeUtils.containMedicalIndustry(industryCodeList);
        boolean containNonMedicalIndustry = IndustryTypeUtils.containNonMedicalIndustry(industryCodeList);

        //0都没有 1医用 2非医用 和 3两个都是
        int pType = containMedicalPT && containNonMedicalPT ? 3 :
                containMedicalPT && !containNonMedicalPT ? 1 :
                !containMedicalPT && containNonMedicalPT ? 2 : 0;
        boolean flag = true;
        if(!containUnitPT){
            if(pType == 0){
                flag = true;
            }

            if(pType == 1){
                flag = containMedicalIndustry && !containNonMedicalIndustry;
            }

            if(pType == 2){
                flag = !containMedicalIndustry && containNonMedicalIndustry;
            }

            if(pType == 3){
                flag = containMedicalIndustry && containNonMedicalIndustry;
            }
        }else {
            if(pType == 0){
                flag = true;
            }

            if(pType == 1){
                flag = containMedicalIndustry;
            }

            if(pType == 2){
                flag = containNonMedicalIndustry;
            }

            if(pType == 3){
                flag = containMedicalIndustry && containNonMedicalIndustry;
            }
        }

        return flag;
    }
}