package cn.smarthse.radiationTraining.modules.training.provider.training;


import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.training.param.enroll.CropStaffEnrollSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.CorpMyTrainSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.CropTrainingListParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingSearchParam;
import cn.smarthse.radiationTraining.modules.training.vo.training.*;

import java.util.List;

/**
 * @ClassName ITrainingProviderServiceForUser
 * @Description 对外单位用户培训接口
 * @Author chuhy
 * @Date 2022/3/24
 */
public interface ITrainingProviderServiceForCorp {

    /**
     * 单位用户登录-首页-培训列表分页 数据
     * @param param 培训搜索参数
     * @return 培训列表Vo
     * @Author chuhy
     */
    LayuiGridData<TrainingListVo> getTrainingPageListForCorp(TrainingSearchParam param);

    /**
     * 个人中心-各培训状态的数量
     * @param cid
     * @param trainTargetType 培训对象类型(0-用人单位培训; 1-机构培训; 2-放射卫生培训)
     * @return
     */
    List<CropTrainStatusNumVo> getTrainingStatusNumListForCrop(Long cid, Integer trainTargetType);

    /**
     * 查看单位用户的培训基本信息
     * @param param 培训搜索参数
     * @return 培训基础信息Vo
     * @Author chuhy
     */
    TrainingBaseInfoVo getTrainingBaseInfoForCorp(TrainingSearchParam param);

    /**
     * 单位用户登录-首页-培训详情-课程组列表
     * @param tid 培训id
     * @param cid 单位ID
     * @return 培训课程组实体
     * @Author chuhy
     */
    List<TrainingCourseGroupVo> getTrainingCourseGroupForCorp(Long tid, Long cid);

    /**
     * 单位用户登录-首页-培训详情-课程列表
     * @param tid 培训id
     * @param trainCourseGroupId 培训课程组Id
     * @return 培训课程实体
     * @Author chuhy
     */
    List<TrainingCourseVo> getTrainingCourseForCorp(Long tid, Long trainCourseGroupId);


    /**
     * 单位用户中心-我的培训 培训列表分页 数据
     * @param param 单位用户-我的培训 搜索参数
     * @return 培训列表Vo
     * @Author chuhy
     */
    LayuiGridData<CorpMyTrainListVo> getMyTrainPageListForCorp(CorpMyTrainSearchParam param);

    /**
     * 查询所有已报名培训的工作类别,用于搜索时的工作类别下拉列表
     * @param cid 单位用户Id
     * @return 工作类别Vo
     * @Author chuhy
     */
    List<TrainingWorkTypeVo> getTrainingWorkType(Long cid);


    /**
     * 单位用户中心-我的培训 培训基本信息(废弃)
     * @param tid 培训Id
     * @return 培训基本信息Vo
     * @Author chuhy
     */
    CorpMyTrainListVo getMyTrainBaseInfoForCorp(Long tid);



    /**
     * 获取单位的培训列表
     * @param param
     * @return
     */
    LayuiGridData<CropTrainingListVo> getCropTrain(CropTrainingListParam param);

    /**
     * 单位用户管理-查看报名人员列表
     * @param param 查询参数
     * @author chuhy
     */
    LayuiGridData<TrainingPersonEnrollVo> getCropTrain(CropStaffEnrollSearchParam param);

    /**
     * 单位-删除人员列表
     * @param param 查询参数
     * @author chuhy
     */
    LayuiGridData<TrainingPersonEnrollVo> listDelEnroll(CropStaffEnrollSearchParam param);
}
