package cn.smarthse.radiationTraining.modules.training.provider.training;


import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingChangeRecord;
import cn.smarthse.radiationTraining.modules.training.param.training.*;
import cn.smarthse.radiationTraining.modules.training.vo.training.*;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @ClassName ITrainingProviderService
 * @Description 对外培训接口
 * @author chuhy
 * @Date 2022/3/11
 */
public interface ITrainingProviderService {

    /**
     * 获取培训管理列表
     * @param param 培训搜索参数
     * @return 培训列表Vo
     * @author chuhy
     */
    LayuiGridData<TrainingListVo> getTrainingList(TrainingSearchParam param);

    /**
     * 查看培训基本信息与在线考试信息
     * @param param 培训搜索参数
     * @return 培训详情(基本信息 考试信息)Vo
     * @author chuhy
     */
    TrainingDetailVo getTrainingInfo(TrainingSearchParam param);

    /**
     * 查看培训基本信息与在线考试信息
     * @param tid 培训id
     * @return 培训详情(基本信息 考试信息)Vo
     * @author chuhy
     */
    TrainingDetailVo getTrainingInfo(Long tid);

    /**
     * 查询所有培训的工作类别,用于搜索时的工作类别下拉列表
     * @return 工作类别Vo
     * @author chuhy
     */
    List<TrainingWorkTypeVo> getTrainingWorkType();

    /**
     * 查询不同培训状态的工作类别
     * @param status (0-已下架；1-草稿；2-已上架；null-所有状态)
     * @return 工作类别Vo
     * @author chuhy
     */
    List<TrainingWorkTypeVo> getTrainWorkTypeByStatus(Integer status);

    /**
     * 查看培训-单位报名列表
     * @param param 培训搜索参数
     * @return 单位用户列表Vo
     * @author chuhy
     */
    LayuiGridData<TrainingUnitEnrollVo> getTrainingUnitEnrollList(TrainingEnrollSearchParam param);

    /**
     * 查看培训-个人报名列表
     * @param param 培训搜索参数
     * @return 个人用户列表Vo
     * @author chuhy
     */
    LayuiGridData<TrainingPersonEnrollVo> getTrainingPersonEnrollList(TrainingEnrollDetailSearchParam param);

    /**
     * 编辑培训详情(基本信息、考试信息)
     * @param param 编辑培训参数
     * @author chuhy
     */
    Integer updateTrainingDetail(TrainingUpdateParam param) throws IllegalAccessException;

    /**
     * 查看培训变更记录
     * @param param 培训id
     * @author chuhy
     */
    LayuiGridData<TrainingChangeRecord> listTrainChangeRecord(TidParam param);


    /**
     * 编辑培训-课程
     * @param param 培训上下架状态参数
     * @author chuhy
     */
    Integer changeTrainingStatus(TrainingStatusUpdateParam param);

    /**
     * 后台 首页数据统计
     * @param areaId 区域id
     * @param level 区域等级
     * @param year 年份
     * @return 后台数据统计Vo
     * @author chuhy
     */
    LayuiGridData<TrainingHomeVo> getTrainingHomeList(TrainHomeListParam param);

    /**
     * 清单 - 数据统计
     * @param param
     * @return 后台数据统计Vo
     * @author chuhy
     */
    LayuiGridData<TrainingHomeListVo> getUntrainedList(TrainHomeListParam param);

    /**
     * 用人单位培训档案
     * @param param
     * @return 后台数据统计Vo
     * @author chuhy
     */
    LayuiGridData<TrainHomeCropVo> getCropTrainList(TrainHomeCropParam param);

    /**
     * 用人单位培训档案-导出
     * @param param
     * @return 后台数据统计Vo
     * @author chuhy
     */
    List<TrainHomeCropExportVo> getCropTrainExportList(TrainHomeCropParam param);

    /**
     * 放射卫生在线-用人单位培训档案
     * @author chuhy
     * @date 2024/9/10 11:04
     */
    LayuiGridData<RhoTrainHomeCropVo> getCropTrainListForRho(RhoTrainHomeCropParam param);

    /**
     * 人员档案
     * @param param
     * @return 后台数据统计Vo
     * @author chuhy
     */
    LayuiGridData<TrainHomeUserVo> getUserTrainList(TrainHomeUserParam param);

    /**
     * 人员档案-证书信息
     * @param param
     * @return 后台数据统计Vo
     * @author chuhy
     */
    List<TrainHomeCetVo> getUserCetList(TrainHomeCetParam param);

    /**
     * 人员培训证书档案 - 导出
     * @param param
     * @return {@link List< TrainHomeUserExportVo>}
     * @author chuhy
     * @date 2024/3/13 13:31
     */
    List<TrainHomeUserExportVo> getUserTrainCetExportList(TrainHomeUserParam param);


    /**
     * 新增培训
     * @param param 新增培训参数
     * @author chuhy
     */
    Long addTrainingDetail(TrainingAddParam param);


    /**
     * 删除培训
     * @param param 培训删除参数
     * @author chuhy
     */
    Integer removeBatchTrainingInfo(TrainingDelParam param);

    /**
     * 克隆培训
     * @param tid 培训id
     * @param userId 后台用户id
     * @author chuhy
     */
    Long cloneTrainByTid(Long tid, Long userId, Boolean isSpecifiedUser,String version);


    // ForApi-------------------------------------------------------------------------------
    /**
     * 首页 培训列表分页 数据
     * @param param 培训搜索参数
     * @return 培训列表Vo
     * @author chuhy
     */
    LayuiGridData<TrainingListVo> getTrainingPageListForApi(TrainingSearchParam param);

    TrainingBaseInfoVo getTrainingBaseInfo(TrainingSearchParam param);


    /**
     * 用于同步更新hse中的培训区域
     */
    Integer updateHseTrainArea();


    /**
     * 手动同步培训消息至职业健康在线
     * @param tid 培训id
     * @return {@link null}
     * @author chuhy
     * @date 2023/6/2 15:44
     */
    void manuallySyncTrainInfo(Long tid);


    // *************************************** 放射卫生在线 ********************************************
    /**
     * 放射卫生在线-人员档案
     * @param param
     * @return {@link LayuiGridData< RhoTrainHomeUserVo>}
     * @author chuhy
     * @date 2024/9/10 9:29
     */
    LayuiGridData<RhoTrainHomeUserVo> getUserTrainListForRho(RhoTrainHomeUserParam param);

    /**
     * 协会培训-成绩列表
     * 人员最近一次考试成绩列表
     * @param param
     * @return {@link LayuiGridData< AssoScoreListVo>}
     * @author chuhy
     * @date 2025/5/13 15:33
     */
    LayuiGridData<AssoScoreListVo> listScoreForAssociation(AssoScoreListParam param);

    /**
     * api-成绩综合搜索-按照姓名/手机号精确搜索
     * @param param
     * @return {@link LayuiGridData< ApiScoreSearchVo>}
     * @author chuhy
     * @date 2025/5/21 10:37
     */
    LayuiGridData<ApiScoreSearchVo> searchScoreByUserForApi(PageParam param);

    /**
     * api-成绩综合搜索-按照用人单位名称精确搜索
     * @param param
     * @return {@link LayuiGridData< ApiScoreSearchVo>}
     * @author chuhy
     * @date 2025/5/21 10:37
     */
    LayuiGridData<ApiScoreSearchVo> searchScoreByCompanyForApi(PageParam param);
}
