package cn.smarthse.radiationTraining.modules.training.provider.course;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.modules.training.entity.course.TuCourse;
import cn.smarthse.radiationTraining.modules.training.param.course.TuCoursePageParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.RestoreStuRecordParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.UpdateDurationParam;
import cn.smarthse.radiationTraining.modules.training.vo.course.TuCourseExamCountVo;
import cn.smarthse.radiationTraining.modules.training.vo.course.TuCourseVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CourseGroupCatalogueVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CourseItemCatalogueVo;

import java.util.List;

/**
 * 用户-培训学习课程
 */
public interface ITuCourseProviderService {

    /**
     * 方法描述:  查询用户学习课程
     *
     * @param   tuCourseId 用户课程id
     * @return  TuCourse
     * @author  wuxq
     * @date    2022/3/28
     */
    TuCourse getById(Long tuCourseId);

    /**
     * 方法描述:  查询用户学习课程Vo
     *
     * @param   tuCourseId 用户课程id
     * @author  chuhy
     */
    TuCourse getTuCourseInfoById(Long tuCourseId);

    /**
     * 方法描述:  更新考试结果
     *
     * @param   tuCourseId 用户课程id
     * @param   resultValue 结果：1-未通过，2-已通过
     * @return  TuCourse
     * @author  wuxq
     * @date    2022/3/28
     */
    TuCourse updateExamResult(Long tuCourseId, Integer resultValue, int passTimes,int score,Integer trainMode);
    /**
     * 方法描述:  更新考试结果(集中考试)
     */
    void updateCentralizedExamResult(Long tuEnrollDetailId, Integer resultValue);
    /**
     * 更新学习时长
     * @return
     */
    TuCourse updateStuDuration(UpdateDurationParam param);

    /**
     * 方法描述:  我的考试-考试列表
     *
     * @param   pageParam 查询参数对象
     * @return  LayuiGridData<TuCourseVo>
     * @author  wuxq
     * @date    2022/3/31
     */
    LayuiGridData<TuCourseVo> getTuCourseExamPageList(TuCoursePageParam pageParam);

    /**
     * 方法描述:  个人中心-我的考试 课程考试列表统计
     *
     * @param   loginUserId 当前登录人id
     * @return  TuCourseExamCountVo
     * @author  wuxq
     * @date    2022/4/8
     */
    TuCourseExamCountVo getTuCourseExamCount(Long loginUserId, Long tid);

    /**
     * @description 获取专业培训目录
     * @param tid
     * @param stuStatus
     * @param loginUserId
     * @return java.util.List<cn.smarthse.radiationTraining.modules.training.vo.training.CourseItemCatalogueVo>
     * @author chenliang
     * @date 2022/9/27 14:25:54
     */
    List<CourseGroupCatalogueVo> getCourseCataLogueForMajor(Long tid,Long enrollDetailId, Integer stuStatus, Long loginUserId);
    /**
     * @description 获取精准培训目录
     * @param enrollDetailId 报名id
     * @return java.util.List<cn.smarthse.radiationTraining.modules.training.vo.training.CourseItemCatalogueVo>
     * @author chenliang
     * @date 2022/9/27 14:17:11
     */
    List<CourseItemCatalogueVo> getCourseCataLogueForPrecise(Long enrollDetailId,Integer stuStatus);

    /**
     * 获取服务机构培训学习目录
     * @param tid 培训id
     * @param enrollDetailId 报名id
     * @param stuStatus 课程学习状态
     * @return {@link List< CourseItemCatalogueVo>}
     * @author chenliang
     * @date 2022/12/20 14:01
     */
    List<CourseItemCatalogueVo> getCourseCataLogueForOrg(Long tid, Long enrollDetailId, Integer stuStatus);

    /**
     * @description 恢复某个课程学习记录
     * @param param
     * @return void
     * @author chenliang
     * @date 2022/8/18 16:38:07
     */
    void restoreSingleness(RestoreStuRecordParam param);
    /**
     * @description 恢复整个培训学习记录
     * @param param
     * @return void
     * @author chenliang
     * @date 2022/8/18 16:38:07
     */
    void restoreAll(RestoreStuRecordParam param);

    /**
     * @description 获取考试不通过且剩余考试次数为零的接口（专业培训）
     * @return
     * @author chenliang
     * @date 2022/8/24 14:26:46
     */
    List<CourseItemCatalogueVo> getFlunkedCourse(Long tid, Long enrollDetailId);


    /**
     * @description 清除已经学习完成的tucourse缓存
     *
     * @return void
     * @author chenliang
     * @date 2022/8/25 13:58:25
     */
    void cleanStuiedRecord();

    void syncEnrollInfo(Long id);

    /**
     * 根据培训id、用户id，获取tuCourse
     * @param tid 培训id
     * @param uid 用户id
     * @return 课程集合
     * @Author chuhy
     */
    List<TuCourse> getTuCourseList(Long tid, Long uid);

    /**
     * 根据培训id、用户id，获取课程id集合 用于统一考试
     * @param tid 培训id
     * @param uid 用户id
     * @return 课程id集合
     * @Author chuhy
     */
    List<String> getCourseIdListByTAU(Long tid, Long uid);

    /**
     * 根据培训id、用户id，获取该培训下所有课程的危害因素
     * @param tid 培训id
     * @return 危害因素code集合
     * @Author chuhy
     */
    List<String> getRiskFactorListByTAU(Long tid, Long uid);

    /**
     * @description 更新冗余数据
     * @param tid
     * @param courseItemId
     * @return void
     * @author chenliang
     * @date 2022/10/31 11:06:42
     */
    void updateRedundency(Long tid, Long courseItemId);



    /**
     * 检测培训或者学习记录的所有者
     * @param enrollDetailId
     * @param tuCourseId
     */
    void checkOwner(Long enrollDetailId, Long tuCourseId, Long uid);
}
