package cn.smarthse.radiationTraining.modules.training.provider.certificate;

import cn.smarthse.radiationTraining.core.framework.model.IdsParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import cn.smarthse.radiationTraining.modules.training.entity.certificate.Certificate;
import cn.smarthse.radiationTraining.modules.training.vo.certificate.CertificateVo;

import java.util.List;

/**
 * @ClassName ITrainingProviderService
 * @Description 证书管理 接口
 * @Author wuxq
 * @Date 2022/3/21
 */
public interface ICertificateProviderService {

    /**
     * 方法描述:  证书模板 列表
     *
     * @param   param 查询参数
     * @return  LayuiGridData<CertificateVo>
     * @author  wuxq
     * @date    2022/3/21
     */
    LayuiGridData<CertificateVo> getCertificateList(PageParam param);

    /**
     * 方法描述:  证书列表下拉选择
     *
     * @return  List<CertificateVo>
     * @author  wuxq
     * @date    2022/4/22
     */
    List<Certificate> getCertificateList();

    /**
     * 方法描述:  查询证书模板详情
     *
     * @param   id id
     * @return  Certificate
     * @author  wuxq
     * @date    2022/3/21
     */
    Certificate getCertificateDetailById(Long id);

    /**
     * 方法描述:  新增证书模板
     *
     * @param   certificate 参数对象
     * @return  void
     * @author  wuxq
     * @date    2022/3/21
     */
    void addCertificate(Certificate certificate);

    /**
     * 方法描述:  更新证书模板
     *
     * @param   certificate 参数对象
     * @return  void
     * @author  wuxq
     * @date    2022/3/21
     */
    void updateCertificate(Certificate certificate);

    /**
     * 方法描述:  启用/禁用
     *
     * @param   id 证书模板id
     * @param   status 状态（1：无效；2：有效）
     * @return  boolean
     * @author  wuxq
     * @date    2022/3/21
     */
    boolean updateStatus(Long id, Integer status);

    /**
     * 方法描述:  批量禁用
     *
     * @param   ids ids
     * @param   status 状态（1：无效；2：有效）
     * @return  boolean
     * @author  wuxq
     * @date    2022/4/13
     */
    boolean updateStatusBatch(List<Long> ids, Integer status);

    /**
     * 方法描述:  批量删除
     *
     * @param   ids List<Long>
     * @return  void
     * @author  wuxq
     * @date    2022/3/21
     */
    void deleteBatch(IdsParam ids);

}
