package cn.smarthse.radiationTraining.modules.training.param.training;

import cn.smarthse.radiationTraining.core.framework.annotation.BeanPropertyName;
import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 培训编辑参数对象
 *
 * @author chuhy
 * @date 2022/3/15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class TrainingUpdateParam extends UserEditParam {
    private static final long serialVersionUID = -1614504721551153166L;

    @BeanPropertyName(name="职业健康在线-监管账号id")
    private String token;
    @BeanPropertyName(name="用户ID")
    private Long uid;
    @BeanPropertyName(name="用户名称")
    private String userName;
    @BeanPropertyName(name="用户区域")
    private Long userArea;
    @BeanPropertyName(name="用户区域level")
    private int userAreaLevel;
    @BeanPropertyName(name="更新人")
    private Long updateBy;
    @BeanPropertyName(name="是否为指定账号")
    private Boolean isSpecifiedUser;
    // 以上由后端控制


    @BeanPropertyName(name="培训ID")
    private Long trainingId;

    @BeanPropertyName(name="培训名称")
    private String trainName;

    @BeanPropertyName(name="培训对象(0-用人单位；11-技术服务机构；12-职业健康体检机构；13-技术服务、职业健康体检机构)")
    private Integer trainTarget;

    @BeanPropertyName(name="是否为通用培训(0-否；1-是)")
    private Integer isCurrency = 0;

    @BeanPropertyName(name="培训模式(0-专业; 1-精准;2-服务机构)")
    private Integer trainMode;

    @BeanPropertyName(name="发送企业类型(0-非直属; 1-省直属;2-市属;3-所有)")
    private Integer sendBelong = 3;


    @BeanPropertyName(name="报名开始时间")
    private Date signStarTime;


    @BeanPropertyName(name="报名结束时间")
    private Date signEndTime;


    @BeanPropertyName(name="培训开始时间")
    private Date trainStarTime;


    @BeanPropertyName(name="培训结束时间")
    private Date trainEndTime;


    @BeanPropertyName(name="培训类型")
    private String trainType;


    @BeanPropertyName(name="是否收费(0-不收费；1-收费)")
    private Byte isCharge;

    @BeanPropertyName(name="收费金额")
    private BigDecimal price;


    @BeanPropertyName(name="封面url")
    private String coverUrl;

    @BeanPropertyName(name="是否在线考试(0-否；1-是)")
    private Integer isTestOnline;

    @BeanPropertyName(name="培训区域id")
    private Long trainArea;


    @BeanPropertyName(name="重考次数限制(-10 不限次数)")
    private Integer retestLimit;


    @BeanPropertyName(name="考试截至时间")
    private Date testEndTime;


    @BeanPropertyName(name="重考设置(0-原题重考；1-原题打乱；2-重组试卷)")
    private Byte retestSetting;


    @BeanPropertyName(name="考试方式(0-分别考试；1-统一考试)")
    private Byte testMode;


    @BeanPropertyName(name="试卷使用方式(1-学院共用；2-随机分配)")
    private Byte testPaperUsage;


    @BeanPropertyName(name="状态(0-已下架；1-草稿；2-已上架)")
    private Byte status;

    @BeanPropertyName(name="人脸识别(0-不需要;1-需要)")
    private Byte isFaceRecognition;


    @BeanPropertyName(name="统一考试 - 试卷结构表id")
    private Long paperStructureId;

    @BeanPropertyName(name="统一考试 - 试卷结构表名称")
    private String paperStructureName;

    @BeanPropertyName(name="统一考试 - 总分")
    private Integer totalScore;

    @BeanPropertyName(name="统一考试 - 答题时长(分钟)")
    private Integer testDuration;

    @BeanPropertyName(name="统一考试 - 及格分数")
    private Integer passingScore;
    /**
     * 组卷方式（默认1：自动；2：手动）
     */
    @BeanPropertyName(name="组卷方式（默认1：自动；2：手动）")
    private Long way;
    /**
     * 单选题数
     */
    @BeanPropertyName(name="单选题数")
    private Integer singleNum;
    /**
     * 多选题数
     */
    @BeanPropertyName(name="多选题数")
    private Integer multipleNum;
    /**
     * 填空题数
     */
    @BeanPropertyName(name="填空题数")
    private Integer completionNum;
    /**
     * 判断题数
     */
    @BeanPropertyName(name="判断题数")
    private Integer judgeNum;
    /**
     * 每个单选题分数
     */
    @BeanPropertyName(name="每个单选题分数")
    private Integer singleScore;
    /**
     * 每个多选题分数
     */
    @BeanPropertyName(name="每个多选题分数")
    private Integer multipleScore;
    /**
     * 每个填空题分数
     */
    @BeanPropertyName(name="每个填空题分数")
    private Integer completionScore;
    /**
     * 每个判断题分数
     */
    @BeanPropertyName(name="每个判断题分数")
    private Integer judgeScore;


    @BeanPropertyName(name="培训人员类型及证书信息")
    private List<PersonTypeCertificateAddParam> personTypeCertificateList;

    @BeanPropertyName(name="行业")
    private List<TrainIndustryAddParam> trainIndustryList;

    @BeanPropertyName(name="精准培训 - 目标学时")
    private Double targetClassHour;

    @BeanPropertyName(name="精准培训 - 通用课程学时")
    private Double generalClassHour;

    @BeanPropertyName(name="修改人")
    private String modifyPerson;

    @BeanPropertyName(name="人员类型是否被修改(0-否；1-是)")
    private Integer isPersonTypeModify;

    @BeanPropertyName(name="行业是否被修改(0-否；1-是)")
    private Integer isIndustryModify;

    public int getUserAreaLevel() {
        return StringUtils.getAreaLevel(this.userArea);
    }

    public TrainingUpdateParam(Long trainingId, String modifyPerson) {
        this.trainingId = trainingId;
        this.modifyPerson = modifyPerson;
    }
}
