package cn.smarthse.radiationTraining.modules.training.param.training;

import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 培训查询参数对象
 *
 * @author chuhy
 * @date
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
public class TrainingSearchParam extends PageParam {

    private static final Long serialVersionUID = -110319853688501078L;

    @ApiModelProperty(value = "用户ID",hidden = true)
    private Long uid;

    @ApiModelProperty(value = "企业ID")
    private Long cid;

    @ApiModelProperty(value = "是否为指定账号",hidden = true)
    private Boolean isSpecifiedUser = false;

    @ApiModelProperty("培训ID")
    private Long trainingId;

    @ApiModelProperty("适用工作类别")
    private String workType;

    @ApiModelProperty("培训类型")
    private String trainType;

    @ApiModelProperty("培训模式(0-专业; 1-精准;2-服务机构)")
    private Integer trainMode;

    /**
     * -1放射培训(包括了医用和非医用)，即21、22、23
     */
    @ApiModelProperty("培训对象(-1放射培训；0-用人单位；21-放射卫生防护管理人员;22-放射工作人员放射防护培训；23-放射(非医))；")
    private Integer trainTarget;

    @ApiModelProperty("人员类型")
    private String personType;

    @ApiModelProperty("状态(0-已下架；1-草稿；2-已上架)")
    private Byte status;

    @ApiModelProperty(value = "培训区域")
    private Long trainAreaId;

    @ApiModelProperty(value = "培训区域level", hidden = true)
    private Integer trainAreaLevel;

    @ApiModelProperty(value = "培训区域范围(1-省；2-市；3-区县；4-街道)")
    private Integer selectTrainAreaLevel;

    @ApiModelProperty(value = "直属企业类型：0-非直属， 1-省直属，2-市属")
    private Integer belongType;

    @ApiModelProperty(value = "报名人数 排序(0-降序;1-升序)")
    private Integer enrollSort;
    @ApiModelProperty(value = "取证人数 排序(0-降序;1-升序)")
    private Integer certSort;


    @ApiModelProperty(value = "监管来源(0-浙里卫企；1-放射卫生在线；3-浙里卫企与放射卫生在线)")
    private Integer supFrom;

    public TrainingSearchParam() {

    }

    public TrainingSearchParam(Long trainingId) {
        this.trainingId = trainingId;
    }

    public Integer getTrainAreaLevel() {
        return StringUtils.getAreaLevel(this.trainAreaId);
    }


}
