package cn.smarthse.radiationTraining.modules.training.param.training;

import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.training.entity.training.Training;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 培训单位报名列表查询参数对象
 *
 * @author chuhy
 * @date
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class TrainingEnrollSearchParam extends PageParam {
    private static final long serialVersionUID = 4385499347039147389L;

    @ApiModelProperty("培训ID")
    private Long trainingId;

    @ApiModelProperty("状态(0-退回；1-待培训；2-培训中；3-培训结束)")
    private Byte status;

    @ApiModelProperty(hidden = true)
    private Byte isCreditCode;

    @ApiModelProperty("参训进度(0-无人员报名;1-有人员未学习;2-有人员未考试;3-有人员未取证;4-人员全部取证)")
    private Byte trainingProgress;

    @ApiModelProperty(value = "是否为指定账号",hidden = true)
    private Boolean isSpecifiedUser = false;

    @ApiModelProperty(value = "用户区域",hidden = true)
    private Long userArea;

    @ApiModelProperty(value = "用户区域level",hidden = true)
    private int userAreaLevel;

    public int getUserAreaLevel() {
        return StringUtils.getAreaLevel(this.userArea);
    }

}
