package cn.smarthse.radiationTraining.modules.training.param.training;

import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 培训查询参数对象
 *
 * @author chuhy
 * @date
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class TrainingCourseParam extends PageParam {
    private static final long serialVersionUID = -1564151480578719417L;

    @ApiModelProperty("培训id")
    private Long trainId;

    @ApiModelProperty("培训课程组id(training_course_group表的Id)")
    private Long trainCourseGroupId;

    // @ApiModelProperty("课程id")
    // private Long courseId;


    public TrainingCourseParam(Long trainId, Long trainCourseGroupId) {
        this.trainId = trainId;
        this.trainCourseGroupId = trainCourseGroupId;
    }
}
