package cn.smarthse.radiationTraining.modules.training.param.training;

import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 培训新增参数对象
 *
 * @author chuhy
 * @date
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class TrainingAddParam extends UserEditParam {

    private static final Long serialVersionUID = -110319853688501078L;

    @ApiModelProperty(value = "用户ID",hidden = true)
    private Long uid;

    @ApiModelProperty(value = "用户区域",hidden = true)
    private Long userArea;

    @ApiModelProperty(value = "职业健康在线-监管账号id", hidden = true)
    private String token;

    @ApiModelProperty(value = "用户区域level",hidden = true)
    private int userAreaLevel;

    @ApiModelProperty(value = "培训版本",hidden = true)
    private String version;

    @ApiModelProperty("创建人")
    private Long createBy;

    @ApiModelProperty("更新人")
    private Long updateBy;

    @ApiModelProperty("培训ID")
    private Long trainingId;


    @ApiModelProperty("培训名称")
    private String trainName;

    @ApiModelProperty("培训对象(0-用人单位；11-技术服务机构；12-职业健康体检机构；13-技术服务、职业健康体检机构)")
    private Integer trainTarget;

    @ApiModelProperty("是否为通用培训(0-否；1-是)")
    private Integer isCurrency = 0;

    @ApiModelProperty(value = "培训模式(0-专业; 1-精准;2-服务机构)")
    private Integer trainMode;

    @ApiModelProperty(value = "发送企业类型(0-非直属; 1-省直属;2-市属;3-所有)")
    private Integer sendBelong = 3;


    @ApiModelProperty("报名开始时间")
    private Date signStarTime;


    @ApiModelProperty("报名结束时间")
    private Date signEndTime;


    @ApiModelProperty("培训开始时间")
    private Date trainStarTime;


    @ApiModelProperty("培训结束时间")
    private Date trainEndTime;


    @ApiModelProperty("培训类型")
    private String trainType;

    // @ApiModelProperty("适用工作类别Code")
    // private List<String> workTypeCodeList;


    @ApiModelProperty("是否收费(0-不收费；1-收费)")
    private Byte isCharge;

    @ApiModelProperty("收费金额")
    private BigDecimal price;

    @ApiModelProperty("封面url")
    private String coverUrl;

    @ApiModelProperty("是否在线考试(0-否；1-是)")
    private Integer isTestOnline;

    @ApiModelProperty("培训区域id")
    private Long trainArea;

    @ApiModelProperty("重考次数限制(-10 不限次数)")
    private Integer retestLimit;


    @ApiModelProperty("考试截至时间")
    private Date testEndTime;


    @ApiModelProperty("重考设置(0-原题重考；1-原题打乱；2-重组试卷)")
    private Byte retestSetting;


    @ApiModelProperty("考试方式(0-分别考试；1-统一考试)")
    private Byte testMode;


    @ApiModelProperty("试卷使用方式(1-学院共用；2-随机分配)")
    private Byte testPaperUsage;

    @ApiModelProperty("状态(0-已下架；1-草稿；2-已上架)")
    private Byte status;

    @ApiModelProperty("人脸识别(0-不需要;1-需要)")
    private Byte isFaceRecognition;


    @ApiModelProperty("统一考试 - 试卷结构表id")
    private Long paperStructureId;


    @ApiModelProperty("统一考试 - 试卷结构表名称")
    private String paperStructureName;

    @ApiModelProperty("统一考试 - 总分")
    private Integer totalScore;

    @ApiModelProperty("统一考试 - 答题时长(分钟)")
    private Integer testDuration;

    @ApiModelProperty("统一考试 - 及格分数")
    private Integer passingScore;

    /**
     * 组卷方式（默认1：自动；2：手动）
     */
    @ApiModelProperty(value = "组卷方式（默认1：自动；2：手动）")
    private Long way;
    /**
     * 单选题数
     */
    @ApiModelProperty(value = "单选题数")
    private Integer singleNum;
    /**
     * 多选题数
     */
    @ApiModelProperty(value = "多选题数")
    private Integer multipleNum;
    /**
     * 填空题数
     */
    @ApiModelProperty(value = "填空题数")
    private Integer completionNum;
    /**
     * 判断题数
     */
    @ApiModelProperty(value = "判断题数")
    private Integer judgeNum;
    /**
     * 每个单选题分数
     */
    @ApiModelProperty(value = "每个单选题分数")
    private Integer singleScore;
    /**
     * 每个多选题分数
     */
    @ApiModelProperty(value = "每个多选题分数")
    private Integer multipleScore;
    /**
     * 每个填空题分数
     */
    @ApiModelProperty(value = "每个填空题分数")
    private Integer completionScore;
    /**
     * 每个判断题分数
     */
    @ApiModelProperty(value = "每个判断题分数")
    private Integer judgeScore;


    @ApiModelProperty(value = "可编辑区域id")
    private Long couldModifyArea;

    @ApiModelProperty(value = "创建者名称")
    private String createName;

    @ApiModelProperty("培训人员类型及证书信息")
    private List<PersonTypeCertificateAddParam> personTypeCertificateList;

    @ApiModelProperty("行业")
    private List<TrainIndustryAddParam> trainIndustryList;

    @ApiModelProperty("精准培训 - 目标学时")
    private Double targetClassHour;

    @ApiModelProperty("精准培训 - 通用课程学时")
    private Double generalClassHour;

    @ApiModelProperty(value = "修改内容", hidden = true)
    private String changeInfo;

    @ApiModelProperty(value = "是否为指定账号",hidden = true)
    private Boolean isSpecifiedUser;

    public TrainingAddParam(String token) {
        this.token = token;
    }
}
