package cn.smarthse.radiationTraining.modules.training.param.training;

import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemPersonType;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseWorkTypeVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingNewCourseVo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.beans.Transient;
import java.util.List;

/**
 * 新增培训-课程组参数对象
 *
 * @author chuhy
 * @date
 */
@Data
@EqualsAndHashCode(callSuper = false)
@JsonIgnoreProperties(ignoreUnknown = true)
public class TrainNewCourseGroupParam extends UserEditParam {
    private static final long serialVersionUID = -7889411093853998888L;

    @ApiModelProperty("培训id")
    private Long tid;

    @ApiModelProperty(value = "培训课程组id(即trainCourseGroupId)",hidden = true)
    private Long id;

    @ApiModelProperty("课程组序号")
    private Integer groupIndex;

    @ApiModelProperty("课程组Id")
    private Long courseGroupId;

    @ApiModelProperty("课程组名称")
    private String courseGroupName;

    @JsonIgnore
    @ApiModelProperty("适用工作类别")
    private List<CourseWorkTypeVo> workType;

    @JsonIgnore
    @ApiModelProperty("人员类型")
    private List<CourseItemPersonType> personType;

    @ApiModelProperty("行业code，英文逗号隔开")
    private String industry;
    @ApiModelProperty("危害因素code，英文逗号隔开")
    private String riskFactor;
    @ApiModelProperty("人员类型code，英文逗号隔开")
    private String personTypeCode;

    @ApiModelProperty("课程集合")
    private List<TrainingNewCourseVo> courseList;

    @ApiModelProperty("（前端冗余字段，用于他们判断使用，与业务无关）系统的默认课程组不能删除")
    private Integer isSystem;

}
