package cn.smarthse.radiationTraining.modules.training.param.training;

import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 放射卫生在线-人员档案列表参数对象
 *
 * @author chuhy
 * @date 2022/9/22
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class RhoTrainHomeUserParam extends PageParam {

    private static final long serialVersionUID = 1674952058929418773L;

    @ApiModelProperty(value = "监管用户区域",hidden = true)
    private Long userArea;

    @ApiModelProperty(value = "用户区域level",hidden = true)
    private int userAreaLevel;

    @ApiModelProperty(value = "人员类型(1-管理人员;2-工作人员)")
    private Integer type;

    @ApiModelProperty(value = "证书是否有效(0-无有效证书;1-持有效证书)")
    private Integer includeValidCet;


    @ApiModelProperty(value = "是否为指定账号",hidden = true)
    private Boolean isSpecifiedUser = false;

    @ApiModelProperty(value = "个人账号id",hidden = true)
    private List<Long> userIdList;

    public int getUserAreaLevel() {
        return StringUtils.getAreaLevel(this.userArea);
    }
}
