package cn.smarthse.radiationTraining.modules.training.param.training;

import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 协会培训-成绩列表参数对象
 *
 * @author chuhy
 * @date 2025/05/13
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AssoScoreListParam extends PageParam {
    private static final long serialVersionUID = 2665273403618789850L;

    @ApiModelProperty(value = "监管用户区域",hidden = true)
    private Long userArea;

    @ApiModelProperty(value = "用户区域level",hidden = true)
    private int userAreaLevel;


    @ApiModelProperty(value = "培训类型")
    private String trainType;


    @ApiModelProperty(value = "是否为指定账号",hidden = true)
    private Boolean isSpecifiedUser = false;

    @ApiModelProperty(value = "个人账号id",hidden = true)
    private List<Long> userIdList;

    public int getUserAreaLevel() {
        return StringUtils.getAreaLevel(this.userArea);
    }
}
