package cn.smarthse.radiationTraining.modules.training.param.enroll;

import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 个人用户-培训列表 查询参数对象
 *
 * @author chuhy
 * @date
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class PersonEnrollCourseParam extends PageParam {
    private static final long serialVersionUID = 7995934255927642561L;

    @ApiModelProperty(value = "用户id")
    private Long uid;

    @ApiModelProperty("培训ID")
    private Long tid;

    @ApiModelProperty("用户报名id")
    private Long enrollDetailId;

    @ApiModelProperty("状态(0-待培训；1-培训中；2-已取证;3-考试未通过；4-考试通过)")
    private Byte status;

    @ApiModelProperty("适用工作类别")
    private String workType;

    @ApiModelProperty("危害因素")
    private String riskFactor;

    @ApiModelProperty(hidden = true,value = "用于标记搜索框的内容是否为身份证号")
    private Byte isIdCard;

}
