package cn.smarthse.radiationTraining.modules.training.param.course;

import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @ClassName CourseItemEditParam
 * 重点行业课程添加参数
 * @Author ChenLiang
 */

@Data
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class KeyCourseFileParam extends UserEditParam {
    @ApiModelProperty(value="数据源id")
    private Long sourceId;

    @ApiModelProperty(value="OSS路径地址（相对）")
    private String ossUrl;

    @ApiModelProperty(value="附件名")
    private String fileName;

    @ApiModelProperty(value="附件大小/B")
    private String fileSize;

    @ApiModelProperty(value="附件扩展名（可用于图标展示）")
    private String fileExt;

    @ApiModelProperty(value="附件Hash")
    private String fileHash;

    @ApiModelProperty(value="上传IP")
    private String creatorIp;

    @ApiModelProperty(value="OSS路径地址(精确)")
    private String fullOssUrl;
}
