package cn.smarthse.radiationTraining.modules.training.param.course;

import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @ClassName CourseItemEditParam
 * @Description 课程编辑参数类
 * @Author ChenLiang
 * @ModifyDate 2022/3/17 8:14
 */
@Data
@Accessors(chain = true)
public class CourseItemEditParam extends UserEditParam {
    @ApiModelProperty("编号")
    private Long courseItemId;

    @ApiModelProperty("组id（添给课程分配组时用到）")
    private Long courseGroupId;

    @ApiModelProperty("工作类别code（添给课程分配工作类别时用到）")
    private String workTypeCode;

    @ApiModelProperty("课程在页面上的顺序（添给课程分配组时用到）")
    private Long pageSequence;
}
