package cn.smarthse.radiationTraining.modules.training.param.course;

import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import cn.smarthse.radiationTraining.core.framework.utils.VideoUtils;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemIndustry;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @ClassName CourseItemEditFullInfoParam
 * @Description TODO
 * @Author ChenLiang
 * @ModifyDate 2022/3/31 16:15
 */
@Data
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CourseItemEditFullInfoParam extends UserEditParam implements Serializable {
    @ApiModelProperty("编号")
    private Long id;

    @ApiModelProperty("课程名称")
    private String name;

    @ApiModelProperty("讲师名称")
    private String lecturer;

    @ApiModelProperty("简介")
    private String description;

    @ApiModelProperty("人员类型")
    private List<CourseItemAddPensonParam> personTypeList;

    @ApiModelProperty("放射危害因数 ")
    private List<CourseItemAddRiskParam> radiationFactorList;

    @ApiModelProperty("行业 ")
    private List<CourseItemAddIndustryParam> industryList;


    @ApiModelProperty("工作类别 code:name")
    private Map<String,String> workType;

    @ApiModelProperty("观看条件（0通用，1专用）枚举：CourseItemPermissionEnum")
    private Integer permissionType;
    @ApiModelProperty("观看条件（0专用，1通用用）枚举：CourseTypeEnum")
    private Integer courseType;
    @ApiModelProperty("区域id")
    private Long areaId;

    @ApiModelProperty("课程组，逗号隔开")
    private String groups;

    @ApiModelProperty("封面:file表id")
    private Long coverId;

    @ApiModelProperty("封面")
    private String coverUrl;

    @ApiModelProperty("视频:file表id")
    private Long videoId;
    @ApiModelProperty("视频:file表id")
    private String videoUrl;

    @ApiModelProperty("腾讯视频id")
    private String txVideoId;

    @ApiModelProperty("腾讯视频url")
    private String txVideoUrl;


    @ApiModelProperty("试卷结构表")
    private Long paperStructureId;


    @ApiModelProperty("视频时长秒")
    private Long videoDurationSec;
    @ApiModelProperty("课时数")
    private Double classHour;

    @ApiModelProperty("状态（0-草稿，1-启用，2-禁用）")
    private Long status;



}
