package cn.smarthse.radiationTraining.modules.training.param.course;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * @Classname CheckEditPermissionParam
 * @Description 校验是否有编辑权限的参数
 * @Date 2023/8/17 13:08
 * @Author chenliang
 */
@Data
@Accessors(chain = true)
public class CheckEditPermissionParam implements Serializable {
    private static final long serialVersionUID = -6665017344125883802L;
    @ApiModelProperty("用户id")
    private Long uid;
    @ApiModelProperty("用户名称")
    private String uname;
    @ApiModelProperty("用户来源（0监管；1浙政厅；2运维端)")
    private Integer userFrom;
    @ApiModelProperty("用户角色")
    private Integer userOptRole;
    @ApiModelProperty("用户区域")
    private Long areaId;

    @ApiModelProperty("课程id列表")
    private List<Long> itemIdList;
    @ApiModelProperty("课程id")
    private Long itemId;
}
