package cn.smarthse.radiationTraining.modules.training.param;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 更新证书状态 参数对象
 *
 * @author wuxq
 * @date
 */
@Accessors(chain = true)
@Data
public class TuCertificateModel implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 证书用户id
     */
    private Long uid;
    /**
     * 培训名称
     */
    private String trainingName;
    /**
     * 姓名
     */
    private String name;
    /**
     * 性别
     */
    private String sex;
    /**
     * 身份证
     */
    private String idcard;
    /**
     * 学历
     */
    private String education;
    /**
     * 证件照
     */
    private String img;
    /**
     * 公章
     */
    private String img2;

    /**
     * 证书pdf附件url
     */
    private String pdfUrl;
    /**
     * 工作单位
     */
    private String workUnit;
    /**
     * 证书编号
     */
    private String certNo;
    /**
     * 培训内容
     */
    private String trainingContent;
    /**
     * 培训课程数
     */
    private String trainingTime;
    /**
     * 考试成绩
     */
    private String score;
    /**
     * 放射工作项目
     */
    private String radiationWork;
    /**
     * 职业照射代码
     */
    private String occExposureCode;
    /**
     * 放射工作开始时间
     */
    private String workBeginTime;
    /**
     * 培训单位
     */
    private String trainingUnit;
    /**
     * 发证日期
     */
    private String issueTime;

    /**
     * 证书背景id(CertBgEnum为准)
     */
    private Long backgroundId;

    public static TuCertificateModel getTestTuCertificateModel() {
        return new TuCertificateModel()
                .setTrainingName("北京市放射工作人员放射防护知识培训合格证")
                .setName("李四").setSex("男").setIdcard("340824199404012899")
                .setEducation("本科").setIssueTime("2020-5-21")
                .setWorkUnit("深圳市科技局").setCertNo("CR-20220411-0001").setTrainingContent("" +
                        "伽马射线探伤照，照马射线探伤照照" +
                        "伽马射线探伤照，" +
                        "")
                .setTrainingTime("2022-4-11").setScore("90").setRadiationWork("放射性污染物检测")
                .setOccExposureCode("05228").setWorkBeginTime("2020-4-11").setTrainingUnit("职业健康培训中心")
                .setImg2("https://yanfa-oss-file1.oss-cn-hangzhou.aliyuncs.com/upload/radiationTraining/common/220412033325591.png")
                .setImg("https://yanfa-oss-file1.oss-cn-hangzhou.aliyuncs.com/upload/radiationTraining/common/220411041540339.jpeg")
                .setBackgroundId(1001L);
    }

}
