package cn.smarthse.radiationTraining.modules.training.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 个人培训状态 枚举
 *
 * @author chuhy
 * @date 2022/3/14
 */
@AllArgsConstructor
@Getter
public enum TuEnrollDetailStatusEnum {

    ALL(-1, "全部"),
    RETURN(0, "退回"),
    BETRAINED(1, "待培训"),
    TRAINING(2, "培训中"),
    OBTAINEDCERTIFICATE(3, "已取证"),
    TRAINOVER(4, "培训结束")
    ;


    private Integer value;

    private String name;

    public static String getName(Integer v) {
        if (v == null) {
            return null;
        }

        for (TuEnrollDetailStatusEnum e : values()) {
            if (e.getValue().equals(v)) {
                return e.getName();
            }
        }
        return null;
    }
}
