package cn.smarthse.radiationTraining.modules.training.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

/**
 * 培训状态 枚举
 *
 * @author wuxq
 * @date 2022/3/14
 */
@AllArgsConstructor
@Getter
public enum TrainingStatusEnum {

    RETURNED(0, "退回"),

    TO_BE_TRAINED(1, "待培训"),

    IN_TRAINING(2, "培训中"),

    GET_CERTIFICATE(3, "已取证"),

    TRAINING_COMPLETED(4, "培训结束");

    private Integer value;

    private String name;

    public static List<Integer> getEnrolledStatus(){
        List<Integer> list = new ArrayList<>();
        list.add(TO_BE_TRAINED.getValue());
        list.add(IN_TRAINING.getValue());
        list.add(GET_CERTIFICATE.getValue());
        list.add(TRAINING_COMPLETED.getValue());
        return list;
    }

}
