package cn.smarthse.radiationTraining.modules.training.enums;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;

import javax.smarthse.radiationTraining.exception.ServiceException;
import java.util.List;

/**
 *
 * 人员类型
 *      主要负责人-200001;  <br>
 *      职业卫生管理人员-200002;  <br>
 *      其他-200000; <br>
 *      职业卫生技术人员(技术服务机构-检测方向)-200004; <br>
 *      放射卫生技术人员(技术服务机构-检测方向)-200005; <br>
 *      职业卫生技术人员(技术服务机构-评价方向)-200006; <br>
 *      放射卫生技术人员(技术服务机构-评价方向)-200007; <br>
 *      职业健康体检主检医师(职业健康体检机构) -200008; <br>
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/8/19 9:44
 */
@AllArgsConstructor
@Getter
public enum TrainingPersonTypeEnum {
    UNIT("0", "全部单位", 100),

    /**
     *  主要负责人-200001
     */
    MAIN_IN_CHARGE("200001", "主要负责人", 1),

    /**
     * 职业卫生管理人员-200002
     */
    HEALTH_ADMIN("200002", "职业卫生管理人员", 2),

    /**
     * 其他-200000
     */
    OTHER("200000", "其他", 0),

    /**
     * 职业卫生技术人员(技术服务机构-检测方向)-200004
     */
    OCCUPATION_TECH_CHECK("200004", "职业卫生检测技术人员", 4),

    /**
     * 放射卫生技术人员(技术服务机构-检测方向)-200005
     */
    RADIO_TECH_CHECK("200005", "放射卫生检测技术人员", 5),

    /**
     * 职业卫生技术人员(技术服务机构-评价方向)-200006
     */
    OCCUPATION_TECH_APPRAISE("200006", "职业卫生评价技术人员", 6),

    /**
     * 放射卫生技术人员(技术服务机构-评价方向)-200007
     */
    RADIO_TECH_APPRAISE("200007", "放射卫生评价技术人员", 7),

    /**
     * 职业健康体检主检医师(职业健康体检机构)-200008
     */
    PHYSICAL_EXAMINATION_DOC("200008", "职业健康体检主检医师", 8),


    RAY_PROTECTION("300001", "放射卫生防护管理人员", 1),
    RAY_WORK("300002", "放射诊疗机构放射工作人员", 2),
    @Deprecated
    RAY_WORK_NON_MEDICAL("300003", "（非医用）放射工作人员", 3),

    ;

    private String value;

    private String name;

    private int tcode;

    TrainingPersonTypeEnum(String value, String name, Integer tcode) {
        this.value = value;
        this.name = name;
        this.tcode = tcode;
    }

    /**
     * 获取职业健康在线 类型编码
     * @param value
     * @return {@link String}
     * @author liaoly
     * @date 2022/8/22 17:08
     */
    public static Integer getTcode(String value) {
        if (value == null) {
            return OTHER.getTcode();
        }

        for (TrainingPersonTypeEnum e : values()) {
            if (e.getValue().equals(value)) {
                return e.getTcode();
            }
        }

        return OTHER.getTcode();
    }

    /**
     * 获取职业健康在线 类型编码 (2位) 01 or 02
     * @param value
     * @return {@link String}
     * @author liaoly
     * @date 2022/8/22 17:08
     */
    public static String getValue2(String value) {

        return value.substring(value.length() - 2);
    }

    public static String getNameByValue2(String v) {
        if (v == null) {
            return null;
        }

        for (TrainingPersonTypeEnum e : values()) {
            if (e.getValue().equals(v)) {
                return e.getName();
            }
        }
        return null;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getTcode() {
        return tcode;
    }

    public void setTcode(int tcode) {
        this.tcode = tcode;
    }

    /**
     * 是否是机构服务人员类型
     * @param value
     * @return {@link Boolean}
     * @author chenliang
     * @date 2022/12/19 10:38
     */
    public static Boolean isOrgCode(String value){
        if(StringUtils.isEmpty(value)){
            throw new ServiceException("人员类型不能为空");
        }
        if(TrainingPersonTypeEnum.OCCUPATION_TECH_CHECK.getValue().equals(value)
                || TrainingPersonTypeEnum.RADIO_TECH_CHECK.getValue().equals(value)
                || TrainingPersonTypeEnum.OCCUPATION_TECH_APPRAISE.getValue().equals(value)
                || TrainingPersonTypeEnum.RADIO_TECH_APPRAISE.getValue().equals(value)
                || TrainingPersonTypeEnum.PHYSICAL_EXAMINATION_DOC.getValue().equals(value)){
            return true;
        }else {
            return false;
        }
    }

    public static Boolean isHseCode(String value){
        if(StringUtils.isEmpty(value)){
            throw new ServiceException("人员类型不能为空");
        }
        if(TrainingPersonTypeEnum.MAIN_IN_CHARGE.getValue().equals(value)
                || TrainingPersonTypeEnum.HEALTH_ADMIN.getValue().equals(value)
                || TrainingPersonTypeEnum.RAY_WORK_NON_MEDICAL.getValue().equals(value)
        ){
            return true;
        }else {
            return false;
        }
    }

    public static Boolean isRhoCode(String value){
        if(StringUtils.isEmpty(value)){
            throw new ServiceException("人员类型不能为空");
        }
        if(TrainingPersonTypeEnum.RAY_PROTECTION.getValue().equals(value)
                || TrainingPersonTypeEnum.RAY_WORK.getValue().equals(value)){
            return true;
        }else {
            return false;
        }
    }
    /**
     * 是否是机构服务人员类型
     * @param values
     * @return {@link Boolean}
     * @author chenliang
     * @date 2022/12/19 10:38
     */
    public static Boolean isOrgCodes(List<String> values){
        if(CollectionUtil.isEmpty(values)){
            throw new ServiceException("人员类型不能为空");
        }
        for (String v : values) {
            if(!isOrgCode(v)){
                return false;
            }
        }
        return true;
    }
    public static Boolean isHseCodes(List<String> values){
        if(CollectionUtil.isEmpty(values)){
            throw new ServiceException("人员类型不能为空");
        }
        for (String v : values) {
            if(!isHseCode(v)){
                return false;
            }
        }
        return true;
    }
    public static Boolean isRhoCodes(List<String> values){
        if(CollectionUtil.isEmpty(values)){
            throw new ServiceException("人员类型不能为空");
        }
        for (String v : values) {
            if(!isRhoCode(v)){
                return false;
            }
        }
        return true;
    }


    public static String getNameByValue(String value){
        if(value == null){
            throw new ServiceException("人员类型不能为空");
        }

        for (TrainingPersonTypeEnum a : TrainingPersonTypeEnum.values()){
            if(a.getValue().equals(value) ){
                return a.getName();
            }

        }

        return "";
    }
}
