package cn.smarthse.radiationTraining.modules.training.enums;

import lombok.Getter;

/**
 *
 * 证书枚举
 * 金色背景-横版 1000 金色背景-竖版 1001
 * 灰蓝背景-横版 1010 灰蓝背景-竖版 1011
 * 绿色背景-横版 1020 绿色背景-竖版 1021
 * 红色背景-横版 1030 红色背景-竖版 1031
 *
 * 技术服务机构-金色背景-横版-2000 技术服务机构-金色背景-竖版-2000
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/8/15 9:24
 */
@Getter
public enum CertBgEnum {

    /**
     *  金色背景-横版 1000
     */
    GOLD_C(1000L, "金色背景-横版" , "gold", "#E7C485", "c","c"),
    
    /**
     * 金色背景-竖版
     */
    GOLD_V(1001L, "金色背景-竖版", "gold", "#E7C485", "v","v"),

    GRAY_C(1010L, "灰蓝背景-横版" , "gray", "#768298", "c","c"),
    GRAY_V(1011L, "灰蓝背景-竖版" , "gray", "#768298", "v","v"),

    GREEN_C(1020L, "绿色背景-横版" , "green", "#78AF64", "c","c"),
    GREEN_V(1021L, "绿色背景-竖版" , "green", "#78AF64", "v","v"),

    RED_C(1030L, "红色背景-横版" , "red", "#621014", "c","c"),
    RED_V(1031L, "红色背景-竖版" , "red", "#621014", "v","v"),

    JG_C(2000L, "技术服务机构-金色背景-横版", "gold", "#E7C485", "jg_c","c"),
    JG_V(2001L, "技术服务机构-金色背景-竖版", "gold", "#E7C485", "jg_v","v"),

    RAY_MANAGER_C(3000L, "放射卫生在线-放射卫生防护管理人员-灰蓝色背景-横版", "gray", "#768298", "c_ray_manager","c"),
    RAY_MANAGER_V(3001L, "放射卫生在线-放射卫生防护管理人员-灰蓝色背景-竖版", "gray", "#768298", "v_ray_manager","v"),
    RAY_WORK_V(3002L, "放射卫生在线-放射工作人员放射防护培训-灰蓝色背景-竖版", "gray", "#768298", "v_ray_work","v"),
    RAY_WORK_V2(3003L, "放射卫生在线-放射工作人员放射防护培训-灰蓝色背景-竖版(岗前专用)", "gray", "#768298", "v_ray_work_pre","v"),

    ;

    
    private final Long value;

    private final String name;

    private final String color;

    private final String colorValue;

    private final String layout;

    private final String layoutType;

    CertBgEnum(Long value, String name, String color, String colorValue, String layout, String layoutType) {
        this.value = value;
        this.name = name;
        this.color = color;
        this.colorValue = colorValue;
        this.layout = layout;
        this.layoutType = layoutType;
    }

    /**
     * 获取颜色
     * @param value 模板枚举编码
     * @return {@link String}
     * @author liaoly
     * @date 2022/8/15 9:50
     */
    public static String getColor(Long value) {
        if (value == null) {
            return null;
        }

        for (CertBgEnum e : values()) {
            if (e.getValue().equals(value)) {
                return e.getColor();
            }
        }

        return null;
    }

    /**
     * 获取颜色 编码值 eg ： 红：#621014
     * @param value 模板枚举编码
     * @return {@link String}
     * @author liaoly
     * @date 2022/8/15 9:50
     */
    public static String getColorValue(Long value) {
        if (value == null) {
            return RED_C.getColorValue();
        }

        for (CertBgEnum e : values()) {
            if (e.getValue().equals(value)) {
                return e.getColorValue();
            }
        }

        return RED_C.getColorValue();
    }

    /**
     * 获取模板排版 （横版还是竖版）
     * @param value 模板枚举编码
     * @return {@link String}
     * @author liaoly
     * @date 2022/8/15 9:51
     */
    public static String getLayout(Long value) {
        if (value == null) {
            return null;
        }

        for (CertBgEnum e : values()) {
            if (e.getValue().equals(value)) {
                return e.getLayout();
            }
        }

        return null;
    }

    public static String getLayoutTypeByValue(Long value) {
        if (value == null) {
            return null;
        }

        for (CertBgEnum e : values()) {
            if (e.getValue().equals(value)) {
                return e.getLayoutType();
            }
        }

        return null;
    }

    /**
     * 获取模板排版是否横向排版
     * @param value 模板枚举编码
     * @return {@link String} 横向排返回true
     * @author liaoly
     * @date 2022/8/15 9:51
     */
    public static boolean isRotate(Long value) {

        return "c".equalsIgnoreCase(getLayoutTypeByValue(value));
    }

    /**
     * 获取证书背景图
     * @param value 模板枚举编码
     * @return {@link String}
     * @author liaoly
     * @date 2022/8/15 9:51
     */
    public static String getBgImg(Long value) {

        String color = getColor(value);
        String layout = getLayout(value);

        return color + "_" + layout + ".png";
    }

    /**
     * 获取证书模板
     * @param value 模板枚举编码
     * @return {@link String}
     * @author liaoly
     * @date 2022/8/15 9:51
     */
    public static String getCertFile(Long value) {

        String layout = getLayout(value);

        return "cert_" + layout + ".html";
    }
}
