package cn.smarthse.radiationTraining.modules.training.entity.training;


import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
@TableName("training")
@NoArgsConstructor
public class Training implements Serializable {
    private static final Long serialVersionUID = 5939003209203518031L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 导入id
     */
    private String importedId;

    /**
     * 批次导入编码（代码自己生成）
     */
    private String importedBatchCode;

    /**
     * 培训名称
     */
    private String trainName;

    @ApiModelProperty("培训对象(0-用人单位；11-技术服务机构；12-职业健康体检机构；13-技术服务、职业健康体检机构)")
    private Integer trainTarget;

    /**
     * 培训类型
     */
    private String trainType;
    /**
     * 版本
     */
    private String version;

    /**
     * 是否为通用培训(0-否；1-是)
     */
    private Integer isCurrency;

    /**
     * 培训模式(0-专业; 1-精准;2-服务机构)
     */
    private Integer trainMode;

    /**
     * 发送企业类型(0-非直属; 1-省直属;2-市属;3-所有)
     */
    private Integer sendBelong = 3;

    /**
     * 报名开始时间
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Date signStarTime;

    /**
     * 报名结束时间
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Date signEndTime;

    /**
     * 培训开始时间
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Date trainStarTime;

    /**
     * 培训结束时间
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Date trainEndTime;

    /**
     * 封面url
     */
    private String coverUrl;

    /**
     * 培训区域id
     */
    private Long trainArea;

    /**
     * 是否收费(0-不收费；1-收费)
     */
    private Byte isCharge;

    /**
     * 收费金额
     */
    private BigDecimal price;

    /**
     * 是否在线考试(0-否；1-是)
     */
    private Integer isTestOnline;

    /**
     * 目标证书Id(certificate.id)
     */
    private Long targetCertificate;

    /**
     * 考试方式(0-分别考试；1-统一考试)
     */
    private Byte testMode;

    /**
     * 试卷使用方式(1-学院共用；2-随机分配)
     */
    private Byte testPaperUsage;

    /**
     * 考试截至时间
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Date testEndTime;
    
    /**
     * 重考次数限制(NULL-不限次数)
     */
     private Integer retestLimit;

    /**
     * 重考设置(0-原题重考；1-原题打乱；2-重组试卷)
     */
     private Byte retestSetting;

    /**
     * 人脸识别(0-不需要;1-需要)
     */
    private Byte isFaceRecognition;

    /**
     * 统一考试 - 试卷结构表id
     */
    private Long paperStructureId;

    /**
     * 统一考试 - 试卷结构表名称
     */
    private String paperStructureName;


    /**
     * 统一考试 - 总分
     */
    private Integer totalScore;

    /**
     * 统一考试 - 答题时长(分钟)
     */
    private Integer testDuration;

    /**
     * 统一考试 - 及格分数
     */
    private Integer passingScore;

    /**
     * 精准培训 - 目标学时
     */
    private Double targetClassHour;

    /**
     * 精准培训 - 通用课程学时
     */
    private Double generalClassHour;

    /**
     * 可编辑区域id(创建者的区域)
     */
    private Long couldModifyArea;

    /**
     * 创建者名称
     */
    private String createName;

    /**
     * 状态(0-已下架；1-草稿；2-已上架)
     */
     private Byte status;

    /**
     * 创建时间
     */
     private Date createTime;

    /**
     * 更新时间
     */
     private Date updateTime;

    /**
     * 创建人
     */
     private Long createBy;

    /**
     * 更新人
     */
     private Long updateBy;

    /**
     * 是否有效(0-无效；1-有效)
     */
    @TableLogic
     private Boolean isValid;

    /**
     * 组卷方式（默认1：自动；2：手动）
     */
    @ApiModelProperty(value = "组卷方式（默认1：自动；2：手动）")
    private Long way;
    /**
     * 单选题数
     */
    @ApiModelProperty(value = "单选题数")
    private Integer singleNum;
    /**
     * 多选题数
     */
    @ApiModelProperty(value = "多选题数")
    private Integer multipleNum;
    /**
     * 填空题数
     */
    @ApiModelProperty(value = "填空题数")
    private Integer completionNum;
    /**
     * 判断题数
     */
    @ApiModelProperty(value = "判断题数")
    private Integer judgeNum;
    /**
     * 每个单选题分数
     */
    @ApiModelProperty(value = "每个单选题分数")
    private Integer singleScore;
    /**
     * 每个多选题分数
     */
    @ApiModelProperty(value = "每个多选题分数")
    private Integer multipleScore;
    /**
     * 每个填空题分数
     */
    @ApiModelProperty(value = "每个填空题分数")
    private Integer completionScore;
    /**
     * 每个判断题分数
     */
    @ApiModelProperty(value = "每个判断题分数")
    private Integer judgeScore;

    public Training(Long id, String trainName, String coverUrl, Integer retestLimit, Byte retestSetting) {
        this.id = id;
        this.trainName = trainName;
        this.coverUrl = coverUrl;
        this.retestLimit = retestLimit;
        this.retestSetting = retestSetting;
    }

    public Training(Long id) {
        this.id = id;
    }
}
